///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////////////
// AskFirstCmd.h: Base class for Cmds that ask for confirmation
////////////////////////////////////////////////////////////////////
#ifndef ASKFIRSTCMD_H
#define ASKFIRSTCMD_H
#include "Cmd.h"

class AskFirstCmd : public Cmd {
    
public:
    
    AskFirstCmd ( const char *, int active = TRUE );
    void setQuestion ( const char *str );
    virtual void execute(); // Overrides the Cmd member function
    virtual const char *const className () { return ( "AskFirstCmd" ); }
    
private:
    
    // Callback for the yes choice on the dialog
    
    static void yesCallback ( void * );
    
    // Derived classes should use setQuestion to change
    // the string displayed in the dialog
    
    char *_question;
};
#endif
















