///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////
// AskFirstCmd.C
//////////////////////////////////////////////////////////
#include "AskFirstCmd.h"
#include "QuestionDialogManager.h"

#define DEFAULTQUESTION "Do you really want to execute this command?"

AskFirstCmd::AskFirstCmd ( const char *name, int active ) : 
Cmd ( name, active )
{
    _question = NULL;
    setQuestion ( DEFAULTQUESTION );
}
void AskFirstCmd::setQuestion ( const char *str )
{
    XtFree ( _question );
    _question = XtNewString ( str );
}
void AskFirstCmd::execute()
{
    theQuestionDialogManager->post ( _question, ( void * ) this,
				     &AskFirstCmd::yesCallback );
}       
void AskFirstCmd::yesCallback ( void *clientData )
{
    AskFirstCmd *obj = (AskFirstCmd *) clientData;
    obj->Cmd::execute();  // Call the base class execute() for
    // usual processing of the command
}














