///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif, 2nd Edition
//         by
//           Douglas Young
//           Prentice Hall, 1995
//           ISBN 0-13-20925507
//
//         Copyright 1995 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////



////////////////////////////////////////////////////////////
// Application.C: 
////////////////////////////////////////////////////////////
#include "Application.h"
#include "MainWindow.h"
#include <assert.h>
#include <stdlib.h>

Application *theApplication = NULL;

Application::Application ( const char *appClassName ) : 
UIComponent ( appClassName )
{
    // Set the global Application pointer
    
    theApplication = this;  
    
    // Initialize data members
    
    _display    = NULL;
    _appContext = NULL;
    _applicationClass = XtNewString ( appClassName );
}
void Application::initialize ( int *argcp, char **argv )
{
    _w = XtAppInitialize ( &_appContext, _applicationClass, NULL, 0, 
			   argcp, argv, NULL, NULL, 0 );
    
    // Extract and save a pointer to the X display structure
    
    _display = XtDisplay ( _w );
    
    // The Application class is less likely to need to handle
    // "surprise" widget destruction than other classes, but
    // install a callback to be safe and consistent
    
    installDestroyHandler();
    
    // Center the shell, and make sure it isnt visible
    
    XtVaSetValues ( _w,
		    XmNmappedWhenManaged, FALSE,
		    XmNx, DisplayWidth ( _display, 0 ) / 2,
		    XmNy, DisplayHeight ( _display, 0 ) / 2,
		    XmNwidth,  1,
		    XmNheight, 1,
		    NULL );
    
    // The instance name of this object was set in the UIComponent 
    // constructor, before the name of the program was available
    // Free the old name and reset it to argv[0]
    
    XtFree ( _name );
    _name = XtNewString ( argv[0] );
    
    // Force the shell window to exist so dialogs popped up from
    // this shell behave correctly
    
    XtRealizeWidget ( _w );
    
    // Initialize and manage any windows registered
    // with this application.
    
    for ( int i = 0; i < _windows.size(); i++ )
    {
	_windows[i]->initialize();
	_windows[i]->manage();
    }
}
Application::~Application()
{
    XtFree ( _applicationClass );
}
void Application::handleEvents()
{
    // Just loop forever
    
    XtAppMainLoop ( _appContext );
}
void Application::registerWindow ( MainWindow *window )
{
    _windows.add ( window );
}
void Application::unregisterWindow ( MainWindow *window )
{
    _windows.remove ( window );
}
void Application::manage()
{
    // Manage all windows, popping up iconified windows as well.
    
    for ( int i = 0; i < _windows.size(); i++ )
	_windows[i]->manage();
}
void Application::unmanage()
{
    // Unmanage all application windows
    
    for ( int i = 0; i < _windows.size(); i++ )
	_windows[i]->unmanage();
}
void Application::iconify()
{
    // Iconify all top-level windows
    
    for ( int i = 0; i < _windows.size(); i++ )
	_windows[i]->iconify();
}

















