///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif
//         by
//           Douglas Young
//           Prentice Hall, 1992
//           ISBN 0-13-630252-1	
//
//         Copyright 1991 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////
// Command.C: Manage a set of command buttons
/////////////////////////////////////////////////////////
#include "stdlib.h"
#include "TicTacToe.h"
#include "Command.h"
#include "Engine.h"
#include <Xm/Form.h>
#include <Xm/PushB.h>

Command::Command ( Widget     parent, 
		  TicTacToe *game, 
		  char      *name ) : UIComponent ( name )
{
    _game = game;	
    
    // Set up an XmForm widget to manage the buttons
    
    _w = XmCreateForm ( parent, _name, NULL, 0 );
    
    installDestroyHandler();	
    
    // Create the command buttons and attach callbacks
    
    _newGame = 
	XtVaCreateManagedWidget ( "newGame", 
				 xmPushButtonWidgetClass, _w,
				 XmNtopOffset,        5,
				 XmNbottomOffset,     5,
				 XmNleftOffset,       5,
				 XmNtopAttachment,    XmATTACH_FORM,
				 XmNleftAttachment,   XmATTACH_FORM,
				 XmNrightAttachment,  XmATTACH_NONE,
				 XmNbottomAttachment, XmATTACH_FORM,
				 NULL );
    
    _quit = 
	XtVaCreateManagedWidget ( "quit", 
				 xmPushButtonWidgetClass, _w,
				 XmNtopOffset,        5,
				 XmNbottomOffset,     5,
				 XmNrightOffset,      5,
				 XmNtopAttachment,    XmATTACH_FORM,
				 XmNleftAttachment,   XmATTACH_NONE,
				 XmNrightAttachment,  XmATTACH_FORM,
				 XmNbottomAttachment, XmATTACH_FORM,
				 NULL );
    
    XtAddCallback ( _newGame, 
		   XmNactivateCallback, 
		   &Command::newGameCallback, 
		   (XtPointer) this );
    
    XtAddCallback ( _quit, 
		   XmNactivateCallback,
		   &Command::quitCallback, 
		   (XtPointer) this );
}

void Command::newGameCallback ( Widget, 
			       XtPointer clientData, 
			       XtPointer )
{
    Command *obj = (Command *) clientData;
    
    obj->newGame();
}

void Command::newGame()
{
    _game->engine()->reset();
}

void Command::quitCallback ( Widget, 
			    XtPointer clientData, 
			    XtPointer )
{
    Command *obj = (Command *) clientData;
    
    obj->quit();
}

void Command::quit()
{
    _game->engine()->quit();
}
