///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//         This example code is from the book:
//
//           Object-Oriented Programming with C++ and OSF/Motif
//         by
//           Douglas Young
//           Prentice Hall, 1992
//           ISBN 0-13-630252-1	
//
//         Copyright 1991 by Prentice Hall
//         All Rights Reserved
//
//  Permission to use, copy, modify, and distribute this software for 
//  any purpose except publication and without fee is hereby granted, provided 
//  that the above copyright notice appear in all copies of the software.
///////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////
// MenuDemoWindow.C: Demonstrate Cmd and MenuBar classes
////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////
// NOTE: This program is similar to the program described in the book, 
// but demonstrates the enhanced CmdList/MenuBar classes that support
// cascading submenus.
//////////////////////////////////////////////////////////////////////

#include "MenuDemoWindow.h"
#include "MenuBar.h"
#include "MenuDemoApp.h"
#include "NoOpCmd.h"
#include "UndoCmd.h"
#include "CmdList.h"
#include <Xm/DrawingA.h>

MenuDemoWindow::MenuDemoWindow ( char *name ) : MenuWindow ( name )
{
    // Create three NoOpCmd objects to demonstrate relationships
    // between objects, as well as MotifApp's undo facility
    
    _a = new NoOpCmd ( "A", TRUE );
    _b = new NoOpCmd ( "B", TRUE );
    _c = new NoOpCmd ( "C", FALSE );
    
    // Set up dependencies between objects. Each command disables
    // itself once it is executed, and enables the other two
    
    _a->addToActivationList ( _b );
    _a->addToActivationList ( _c );
    _a->addToDeactivationList ( _a );
    
    _b->addToActivationList ( _a );
    _b->addToActivationList ( _c );
    _b->addToDeactivationList ( _b );
    
    _c->addToActivationList ( _a );
    _c->addToActivationList ( _b );
    _c->addToDeactivationList ( _c );
}

Widget MenuDemoWindow::createWorkArea ( Widget parent )
{
    _canvas = XtCreateWidget ( "canvas", 
			      xmDrawingAreaWidgetClass,
			      parent, 
			      NULL, 0 );
    return _canvas;    
}

void MenuDemoWindow::createMenuPanes()
{
    CmdList *appCmdList, *xyzCmdList, *abcCmdList, *subCmdList;
    
    // Create an Application pane containing undo, 
    // and other application-wide commands
    
    appCmdList = new CmdList("Application");
    appCmdList->add ( theUndoCmd );        
    appCmdList->add ( theMenuDemoApp->manageCmd() );
    appCmdList->add ( theMenuDemoApp->iconifyCmd() );
    appCmdList->add ( theMenuDemoApp->quitCmd() );
    _menuBar->addCommands ( appCmdList );

    // Create a submenu cmd list

    subCmdList = new CmdList("SubMenu");
    subCmdList->add ( _a );
    subCmdList->add ( _b );
    subCmdList->add ( _c );

    // Create a menu pane of NoOpCmd objects to demonstrate
    // Cmd objects that have multiple interfaces.
    // Note that the _a, _b, and _c commands are
    // present in both this pane (as a submenu)
    // and the following direct menu pane
    
    xyzCmdList = new CmdList("XYZ");
    xyzCmdList->add ( theMenuDemoApp->xCmd() );
    xyzCmdList->add ( theMenuDemoApp->yCmd() );
    xyzCmdList->add ( theMenuDemoApp->zCmd() );
    xyzCmdList->add ( subCmdList );
    _menuBar->addCommands ( xyzCmdList );
    
    // Create a window-specific menu pane, containing 
    // commands that are independent within each window.
    
    abcCmdList = new CmdList("ABC");
    abcCmdList->add ( _a );
    abcCmdList->add ( _b );
    abcCmdList->add ( _c );
    _menuBar->addCommands ( abcCmdList );

}



