
/* Copyright 1997 Kaleb S. KEITHLEY. All Rights Reserved */

#include "showjpg.h"

static void destroy_shell (
    Widget w,
    XEvent* ev,
    String* params,
    Cardinal* num_params)
{
    XtAppContext app = XtWidgetToApplicationContext (w);

    XtDestroyWidget (w);
#if (XtSpecificationRelease == 6)
    XtAppSetExitFlag (app);
#endif
}

void createWidgets (
    int* argc,
    char** argv,
    showjpgstuff data)
{
    XtAppContext app;
    static XtActionsRec actions[] = {
	{"destroy_shell",	destroy_shell}
    };

    XtSetLanguageProc (NULL, NULL, NULL);

#if (XtSpecificationRelease == 5)
    data->top = XtAppInitialize (
#else
    data->top = XtOpenApplication (
#endif
		&app, "JpegViewer", NULL, 0,
		argc, argv, NULL,
#if (XtSpecificationRelease == 6)
		sessionShellWidgetClass,
#endif	
		NULL, 0);

    data->wm_delete_window = XInternAtom (XtDisplay (data->top),
					  "WM_DELETE_WINDOW", False);

    XtAppAddActions (app, actions, XtNumber (actions));

    data->ext_info = XInitExtension (XtDisplay (data->top), "MIT-SHM");
    (void) printf ("%d\n", data->ext_info->first_event);
}

static void exposeEH (
    Widget w,
    XtPointer closure,
    XEvent* ev,
    Boolean* cont)
{
    showjpgstuff data = (showjpgstuff) closure;

    if (data->use_shm) {
	XShmPutImage (XtDisplay (w), XtWindow (w), DefaultGC(XtDisplay (w),0), 
		data->image, 0, 0, 0, 0, 
		data->image->width, data->image->height, 1);
    } else {
	XPutImage (XtDisplay (w), XtWindow (w), DefaultGC(XtDisplay (w),0), 
		data->image, 0, 0, 0, 0, 
		data->image->width, data->image->height);
    }
}

static void destroyCB(
    Widget w,
    XtPointer closure,
    XtPointer client_data)
{
    showjpgstuff data = (showjpgstuff) closure;
    releaseSharedMemory (data);
#if (XtSpecificationRelease < 6)
    exit (0);
#endif
}

#if (XtSpecificationRelease < 6)
static void MyAppMainLoop (
    XtAppContext app,
    showjpgstuff data)
{
    XEvent ev;

    for (;;) {
	XtAppNextEvent (app, &ev);
	if (ev.type == data->ext_info->first_event)
	    (void) printf ("%s\n", "shm putimage complete event");
	else
	    XtDispatchEvent (&ev);
    }
}
#else
#define MyAppMainLoop(a,d) XtAppMainLoop(a)

static Boolean myEventDispatcher (
    XEvent* ev)
{
    XShmCompletionEvent* shmev = (XShmCompletionEvent*) ev;

    return XtDispatchEventToWidget (XtWindowToWidget (shmev->display, shmev->drawable), ev);
}

static void myExtensionSelector (
    Widget w,
    int* event_types,
    XtPointer* select_data,
    int count,
    XtPointer client_data)
{
    /* assert count == 1 */
    XtSetEventDispatcher (XtDisplay (w), event_types[0], myEventDispatcher);
}

static void shmEvTypeHandler (
    Widget w,
    XtPointer closure,
    XEvent* ev,
    Boolean* cont)
{
    (void) printf ("%s\n", "shm putimage complete event");
}
#endif

int putImageInWidget (showjpgstuff data)
{
    Widget shell;
    Arg args[10];
    int n = 0;

    XtSetArg (args[n], XtNwidth, data->image->width); n++;
    XtSetArg (args[n], XtNheight, data->image->height); n++;
    shell = XtCreatePopupShell ("JpegViewerPopup", topLevelShellWidgetClass,
	data->top, args, n);

    XtAddEventHandler (shell, ExposureMask, FALSE, exposeEH, (XtPointer) data);

    XtAddCallback (shell, XtNdestroyCallback, destroyCB, data);

    XtOverrideTranslations (shell, 
	XtParseTranslationTable ("<Message>WM_PROTOCOLS: destroy_shell()"));

#if (XtSpecificationRelease == 6)
    XtRegisterExtensionSelector (XtDisplay(shell), 
	data->ext_info->first_event, 
	data->ext_info->first_event + ShmNumberEvents,
	myExtensionSelector, (XtPointer) data);

    XtInsertEventTypeHandler (shell, data->ext_info->first_event, NULL,
	shmEvTypeHandler, (XtPointer) data, XtListHead);
#endif

    XtPopup (shell, XtGrabNone);

    (void) XSetWMProtocols (XtDisplay(shell), XtWindow(shell),
        &data->wm_delete_window, 1);

    MyAppMainLoop (XtWidgetToApplicationContext (data->top),data);

    return 1;
}

