
/* Copyright 1997 Kaleb S. KEITHLEY. All Rights Reserved */

#include "showjpg.h"
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>

static int got_error = 0;

static int errorHandler (
    Display* dpy,
    XErrorEvent* err_ev)
{
    got_error = 1;
    return 0;
}

int setupSharedMemory (showjpgstuff data)
{
    key_t key;
    XErrorHandler eh;
    Display* dpy = XtDisplay (data->top);

    if (!XShmQueryExtension (dpy))
	return 0;

    data->shm_info.shmid = shmget ((key = (key_t) getpid()), 1024 * 1024, 0666|IPC_CREAT|IPC_EXCL);
    data->shm_info.shmaddr = shmat (data->shm_info.shmid, 0, 0);

    data->shm_info.readOnly = 1;
    eh = XSetErrorHandler (errorHandler);
    XShmAttach (dpy, &data->shm_info);
    XSync (dpy, 0);
    (void) XSetErrorHandler (eh);
    if (got_error) {
	(void) shmdt (data->shm_info.shmaddr);
	(void) shmctl (data->shm_info.shmid, IPC_RMID, NULL);
	return 0;
    }
    return 1;
}

void releaseSharedMemory (showjpgstuff data)
{
    XShmDetach (XtDisplay (data->top), &data->shm_info);
    (void) shmdt (data->shm_info.shmaddr);
    (void) shmctl (data->shm_info.shmid, IPC_RMID, NULL);
}
