/* $XConsortium: square.c /main/3 1996/12/30 16:35:44 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <Xa/Xalib.h>
#include <Xa/atomstrings.h>
#include <Xa/cdefines.h>

#define NOT_TO_SPEC		/* implementatin does not yet match spec */

#define NSAMP 400	/* number of samples */

main( int argc, char *argv[])
{
    char samples[NSAMP], errString[80];
    char sample = 0;
    long count;

    XaAudio audio;
    XaTag port, format;

    /*
    ** fake some samples  (slow but simple);
    */
    for (count = 0; count < NSAMP; count++)
    {
	if (!(count & 0x3))		/* flop every four samples */
	    sample = ~sample;
	samples[count] = sample;
    }
	

    /*
    ** open the audio display, create a prt and foramt, and let 'er rip
    */
    audio = XaOpenAudio("", errString, &argc, argv);
    if (!audio)
    {
	printf("No server!\n");
	exit();
    }
    format = XaCreate(audio, XaNformat, 
	    XaNnumChannels, 1, 
	    NULL);
    port = XaCreate(audio, XaNport, 
#ifndef NOT_TO_SPEC
	    XaNinputBuffer, XaTnone, 
#endif
	    XaNformat, format,
	    NULL);
    XaSet(audio, port,
	    XaNrun, (void *)XaTrue,
	    NULL);
    while(1)
    {
	XaWrite(audio, port, 0, XaAlastAccessTime, samples, 
		sizeof(samples)*8, 0, NULL);
	XaPing(audio, XaFalse, NULL); 	/* needn't be synchronous */
    }
}
