/* $XConsortium: porttest.cc /main/3 1996/12/30 16:35:37 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#include "device.h"
#include "port.h"
#include "intbuffer.h"

void
WatchBuffer(XaTask *t, void *p)
{
    XaInternalBuffer *buf = (XaInternalBuffer *) p;
    XaTimedTask *task = (XaTimedTask *) t;

    if (buf->GetRefCount() == 1)
    {
	// Port write is finished, throw a signal in
	// the scheduler causing it to stop running.
	Scheduler().RaiseException();
    }
    else
    {
        // Schedule us another 1/20 second into the future
	XaWallTime wakeupTime = task->GetTime() + XaWallTime(50);

	task->Reschedule(wakeupTime);
    }
}

int main(int argc, char **argv)
{
    if (argc < 2)
    {
	fprintf(stderr,"Usage: %s <filename>\n", argv[0]);
	exit(0);
    }

    // Create a file reader on the first argument.
    //XaFile *file = new XaFile(argv[1]);
    int fileFD;
  
    fileFD = open(argv[1], O_RDONLY);
    // Read pas the .au header
    lseek (fileFD, 25, SEEK_SET);

    // Create the device object.
    XaDevice *dev = new XaDevice("libdec_msbdevice.so");
    assert (dev != NULL);
    dev->Open(O_WRONLY);

    // Create a port onto the device.
#ifdef NEVER
    XaPort           *port = new XaPort(0, 0, 0, 0, XaFalse, XaFalse, NULL, NULL, dev, 0, 0, 0);
#else
    XaPort           *port = new XaPort(NULL, NULL, XaTnone, XaTnone, XaTnone);
#endif
    // Now shovel bits from the reader to the port.
    XaInternalBuffer *buffer = new XaInternalBuffer(2048);
    void             *buf = buffer->GetBuffer();
    int              bufSize;
    CARD32           numWritten;
    XaErrorCode      err = XaESuccess;
    XaTask           *task;
    XaWallTime       wakeupTime;
    CARD8	     leftPad;
    CARD32	     bitsRead;
    XaTime           devTime;

    assert(buf != NULL);

    while((bufSize = read(fileFD, buf, 2048) > 0))
    {
	// Install a task in the scheduler which throws an exception
	// when the buffer has a refcount of 1.
	buffer->Get(); // bump the refcount up while installing the task
	wakeupTime.Now();
	wakeupTime += XaWallTime(50); // come back in 1/20 second
	task = new XaTimedTask(WatchBuffer, buffer, wakeupTime);
	assert(task != NULL);
	Scheduler().ClearException(); // so the task doesn't immediately come back
	Scheduler().AddTask(*task);

	// Write the buffer to the port (possibly causing async operation)
	err = port->Write((XaTime) 0, XaTnone,
			  *buffer,
			  bufSize * 8, 0, numWritten, devTime);
	if (err != XaESuccess)
	{
	    printf("Error %d when writing to port.\n", err);
	}

	// Release the extra reference so that the only refs are from
	// buffer creation and (possibly) the port write
	buffer->Release();
	
	// Run the scheduler until the watcher task signals done
	Scheduler().Run();
    }

    
    // Take down the port.
    delete port;

    // All done.
    return 0;
}



