/* $XConsortium: main.cc /main/6 1996/12/30 16:23:24 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// @DEC_COPYRIGHT@
//
// HISTORY
// $Log$
// Revision 1.1.1.4  1995/11/30  16:47:12  Peter_Derr
// 	add signal handler
//
// Revision 1.1.1.3  1995/11/29  19:21:41  Peter_Derr
// 	save intermediate work
// 
// Revision 1.1.1.3  1995/10/19  19:57:23  Peter_Derr
// 	handle clients exiting
// 
// Revision 1.1.1.2  1995/10/17  17:50:21  Peter_Derr
// 	first pass at setting up ICE connection
// 
// $EndLog$
// 
// @(#)$RCSfile: main.cc $ $Revision: /main/6 $ (DEC) $Date: 1996/12/30 16:23:24 $
// 
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <time.h>
#include <string.h>

#include "xadefines.h"
#include "atom.h"

#include "scheduler.h"
#include "clientconn.h"
#include "config.h"


/* This is the main server connection.
 * and in general is used as the 
 * way to find out about server state,
 * and affect server behavior.
*/
XaMasterConnection masterConnection;


/*
 * Should be put into an include file
 * that describes the server lifecycle
*/
extern void XaServerShutdown(XaMasterConnection &);
extern void XaServerStartup(XaMasterConnection &);

/* XXXX Is there an official sanctioned version of
 * this some X tree?
*/ 
const char *Now() {
    time_t clock;
    time(&clock);
    return ctime(&clock);
}


// State variable for SignalHandler:
// If we get to ServerShutdown(), we set exiting
// and SignalHandler checks it and returns if we've enered
// it.
static int exiting = 0;
void ServerShutdown() {
    // Might as well check here too.
    if( exiting) return;
    exiting = 1;
    
    fprintf(stderr, "\n\nShutting down X Audio Server: %s", Now());
    
    // Shutdown connections
    masterConnection.cleanup();

    // ... Vendor specific shutdown
    XaServerShutdown(masterConnection);
}

void SignalHandler(int sig) {
    
    if (exiting) return;
    
    switch(sig) {
	
	case SIGINT:
	    // Just print some stats out.
	    if( signal(SIGINT, SignalHandler) == SIG_ERR) {
		fprintf(stderr, "Couldn't reset the SIGINT handler\n");
	    }
	    fprintf(stderr, "\n%sAccepting Connecions through IDS:\n\t%s\n",
		    Now(), masterConnection.connectionIds());
	    fprintf(stderr, "Send SIGQUIT (ctrl-\\) to quit.\n");
	    break;
	    
	default:
	    // Close down the server.
	    ServerShutdown();
	    exit(0);
    }
}

main (int argc, char **argv)
{
    char *listenPort = XA_DEFAULT_LISTEN_PORT;
    XaBoolean noAuth = False;

    /* Get server configuration - XXX this should be inside reset loop */
    _XaCreateConfig(argc, argv, "Xaserver-config", 
	    "XAserver", XaConfigUnknownWarn);
    _XaConfigGetString(".port", "", &listenPort);
    if (_XaConfigGetBool(".auth", "", &noAuth))
	noAuth = !noAuth;			/* noAuth is negative logic */

    /*
     * Server Startup
    */

    // SIGINT spews out information, others shutdown the server
    signal(SIGTERM, SignalHandler);
    signal(SIGINT, SignalHandler);
    signal(SIGQUIT, SignalHandler);

    // Initialize and set up the server.
    masterConnection.setup(listenPort, !noAuth);

    // Local, implementation specific, set up.
    XaServerStartup(masterConnection);

    /*
     * Server Run
    */
    
    // Start processing requests.
    Scheduler().Run();

    
    /*
     * Server Shutdown
    */
    ServerShutdown();
}
