/* $XConsortium: server.cc /main/4 1996/12/30 16:35:15 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
 * Sun specific server lifetime functions
 * 
 * 	@(#)server.cc	1.4 96/03/21 
 * 
*/

#include "clientconn.h"
#include "device.h"
#include "class.h"
#include "port.h"
#include <stdio.h>

/* XXXXX This SHOULDN't be here, it's here to define O_RDONLY
 * and we want to use a different constant. eh?
*/
#include <fcntl.h>

#define DEBUG_ON

static FILE *debug_out = stderr;

#ifdef DEBUG_ON
static int _debug = 1;
#define DEBUG if(_debug)
#else
#define DEBUG if(0)
#endif


void XaServerShutdown(XaMasterConnection &serverConn) {

    // Make a little noise.
    DEBUG {
	fprintf(debug_out, "\nAtom Store at shutdown:\n");
	serverConn.AtomCache().printOn(debug_out);
    }
}

void XaServerStartup(XaMasterConnection &serverConn) {

    // Make some noise ...
    DEBUG {
	fprintf(debug_out, "SMI Audio Server Initialization\n");
	// serverConn.AtomCache().printOn(debug_out);
    }


    
    // ... set up initial devices ...

    //
    // Today we do this by hand, .... tomorrow we'll 
    // do this automatically.
    //

    // Get the Device Class and if it's there start creating devices.
    XaClass *deviceClass = (XaClass*)serverConn.ClassDB().find(XaAdevice);
    if(deviceClass != NULL) {

	// Devices get intiailized from here:
	const char *deviceLibrary = "libsundevice.so";
 	
	// Get the tag for the new device, and create it.
	XaTag deviceTag = serverConn.NewTag();
	XaDevice *playDevice = (XaDevice*)deviceClass->Create(&serverConn,
						    deviceTag, XaAdevice,
						    NULL, 0);
	if(!playDevice) {
	    fprintf(stderr, "Unable to create a device object.\n");
	    return;
	}

	// Initialize and start up the device.
	if(playDevice->init(deviceLibrary) != XaEFailure) {
	    if(playDevice->Open(O_WRONLY) != XaEFailure) {
		// This one is going to be the Default output buffer
		// that Port will "connect" to.
		// We tell port via this variable,
		// at least for now. The Correct thing
		// to do is to have class attributes here.
		XaPort::defaultOutputBuffer = deviceTag;
		DEBUG {
		    fprintf(debug_out, "Init/Open of device.\n");
		}
	    } else {
		fprintf(stderr, "Unable to open the device\n");
	    }
	} else {
	    fprintf(stderr, "Unable to initialize the device from: \"%s\"\n",
		             deviceLibrary);
	}
    } else {
	fprintf(stderr, "Unable to obtain Class: \"%s\"\n", XaNdevice);
    }

}
