/* $XConsortium: osstest.c /main/2 1996/12/30 16:35:12 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <Xalib.h>
#include <atomdefs.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <sys/time.h>
#include <cdevice.h>


extern struct
{
    CARD32 numChannels;
    CARD32 sampleWidth;		/* bits */
    CARD32 bytesPerSample;	/* includes all channels */
    char * ringBufAddr;
    XaTime ringBufSize;
    XaTime transferSize;
    XaTime sampleLimit;
    XaTime hardwareTransferLimit;
    XaTime sampleTransferTarget;
    XaTime currentSample;
    XaTime sampleRate;
    XaAtom encoding;
    XaBoolean DMArunning;
    XaBoolean firstWriteDone;
    char *DMAbuffer;
    unsigned int DMAsize;	/* bytes */
    unsigned int DMAsamples;	/* includes all channels */
    unsigned int DMAwriteIndex;	/* bytes */
    unsigned int DMAlastOffset;	/* bytes */
    unsigned int DMAzeroed;	/* bytes */
} writeParams;

extern void *write_device;
extern struct timeval USSUpdate(void);

int inputFd;

/*
	Stubs of unused functions so test can be linked

SetAttributeGetCB
SetAttributeCheckCB
SetAttributeValidateCB
SetDeviceReadFunc
SetDeviceUpdateTimeFunc
DeviceRingBufConfigure
XaCreateMixingConnector
XaSetDeviceConnector

*/
void SetAttributeGetCB (void              *object,
                        XaAttributeCBData *data,
                        XaAttributeGetCB   myGetCB)
{
return;
}

void SetAttributeCheckCB (void                *object,
                          XaAttributeCBData   *data,
                          XaAttributeCheckCB   myCheckCB)
{
return;
}


void SetAttributeValidateCB (void                   *object,
                             XaAttributeValidateCB   myValidateCB)
{
return;
}

void SetDeviceReadFunc(void *object, DeviceReadFunc myFunc)
{
return;
}

void SetDeviceUpdateTimeFunc(void *object, DeviceTimeUpdateFunc myFunc)
{
return;
}

XaErrorCode DeviceRingBufConfigure(void *object, char **buf, XaTime size,
                                CARD32 nChannels, CARD32 sWidth,
                                XaTime transferSize, XaTime sampleLimit,
                                XaTime hardwareTransferLimit,
                                XaTime currentSample)
{
return 0;
}

void *XaCreateMixingConnector(DeviceUpdateFunc a, DeviceWriteFunc b,
                                DeviceConnectFunc c, DeviceDisconnectFunc d)
{
return NULL;
}

void *XaCreatePassThroughConnector(DeviceUpdateFunc a, DeviceWriteFunc b,
                                DeviceConnectFunc c, DeviceDisconnectFunc d)
{
return NULL;
}

void XaSetDeviceConnector(void *device, void *connector)
{
return;
}

XaErrorCode XaGetAttributes(void *object, XaAttributeCBData *data, 
					    CARD32 count)
{
return 0;
}

void SetAttributeSetCB (void              *object,
			XaAttributeCBData *data, XaAttributeSetCB   mySetCB)
{ return; }

int USSTestInit(XaAtom encoding) 
{

    XaErrorCode returnCode;

    /* Do device specific initialization
     */

    if (0 != USSInit("/dev/dsp0"))
	return -1;

    if (encoding == XaAencodeUlaw)
    {
	/*
	 * XXXXXXXXXXXXXXXXXX
	 * gross hacks to get this to work for now.
	 * Assume 8K sample rate, mono, 8 bits/sample
	 */
	/* init writeParams */
	writeParams.ringBufAddr = NULL;	/* let it create the buffer */
	writeParams.numChannels = 1;
	writeParams.sampleWidth = 8;
	writeParams.bytesPerSample = writeParams.numChannels
						* writeParams.sampleWidth / 8;
	writeParams.transferSize = 2000;
	writeParams.sampleLimit = 1000;
	writeParams.hardwareTransferLimit = 500;
	writeParams.currentSample = -1;
	writeParams.sampleRate = 8000;
	writeParams.sampleTransferTarget = 1.5 * writeParams.sampleRate;
	writeParams.ringBufSize = 4 * writeParams.sampleRate; /* 4secs */
	writeParams.encoding = XaAencodeUlaw;
    }
    else
    {
	/*
	 * XXXXXXXXXXXXXXXXXX
	 * gross hacks assuming CD format
	 * -channels 2 -bitspersample 16 -rate 44100 -encoding pcm
	 */
	/* init writeParams */
	writeParams.ringBufAddr = NULL;	/* let it create the buffer */
	writeParams.numChannels = 2;
	writeParams.sampleWidth = 16;
	writeParams.bytesPerSample = writeParams.numChannels
						* writeParams.sampleWidth / 8;
	writeParams.transferSize = 2000;
	writeParams.sampleLimit = 1000;
	writeParams.hardwareTransferLimit = 3000;
	writeParams.currentSample = -1;
	writeParams.sampleRate = 44100;
	writeParams.sampleTransferTarget = 16384;
	writeParams.ringBufSize = 4 * writeParams.sampleRate; /* 4secs */
	writeParams.encoding = XaAencodeLinear;
    }

    returnCode = USSSetFormat(writeParams.sampleRate, writeParams.encoding,
			writeParams.sampleWidth, writeParams.numChannels);

    if (returnCode != XaESuccess) return returnCode;


    write_device = (void *)1L;

    return 0;
}

#define BUF_SIZE 65532

DeviceWriteTransfer(void *write_device, void *connectId,
			    XaTime atTime, XaAtom refTime,
			    char **buf, CARD32 samplesToRead,
			  CARD32 *samplesRead, XaTime deviceTime)

{

    static char buffer[BUF_SIZE];

    static int bufIndex = 0;
    int bytesRead;

    if (samplesToRead > 42)
	samplesToRead -= 42;
    
    bytesRead = read(inputFd, (void *)buffer,
			samplesToRead * writeParams.bytesPerSample);

    if (bytesRead > 0)
    {
	*samplesRead = bytesRead / writeParams.bytesPerSample;
	*buf = buffer;
	return 0;
    }
    else
    {
	*buf = NULL;
	*samplesRead = 0;
	return 1;
    }
}

main(int argc, char **argv)
{
    struct timeval nextTime;
    XaAtom encoding;

    if (argc < 2)
    {
	printf("Usage: %s file\n", argv[0]);
	exit(1);
    }

    inputFd = open(argv[argc -1], O_RDONLY, 0);
    if (inputFd < 0)
    {
	printf("failure opening input file %s\n", argv[argc - 1]);
	exit(1);
    }
    printf("input fd = %d\n", inputFd);

    if (argc > 2 && (0==strcmp("-cd", argv[1])))
    {
	char tmpBuff[4];

	encoding = XaAencodeLinear;
	/* HACK */
	/* read(inputFd, (void *)tmpBuff, 3); */
    }
    else
	encoding = XaAencodeUlaw;

    if (USSTestInit(encoding))
    {
	printf("USS init failure\n");
	exit(1);
    }

    while (1)
    {
	nextTime = USSUpdate();
	/* sleep(1); */
	{
	    long sampleInterval = writeParams.sampleTransferTarget
					    - writeParams.hardwareTransferLimit;

	    long timeInterval =  1000000 * sampleInterval;
	    
	    timeInterval = timeInterval / writeParams.sampleRate;

	    usleep(timeInterval);
	}
    }
}
