/*
 * Copyright (c) 1996 Digital Equipment Corporation
 * 
 * The X Consortium, and any party obtaining a copy of these files
 * from the X Consortium, directly or indirectly, is granted, free
 * of charge, a full and unrestricted irrevocable, world-wide,
 * paid up, royalty-free, nonexclusive right and license to deal
 * in this software and documentation files (the "Software"),
 * including without limitation the rights to use, copy, modify,
 * merge, publish, distribute, sublicense, and sell copies of the
 * Software, and to permit persons who receive copies from any
 * such party to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the
 * Software.
 * 
 * Digital Equipment Corporation makes no representations about
 * the suitability of this Software for any purpose.  The Software
 * is provided "as is" without express or implied warranty.
 */
 
/* 
 * 
 * Digital specific server lifetime functions
 *
 * 	@(#)server.cc	1.2 96/02/26 
 * 
 */

#include <clientconn.h>
#include <device.h>
#include <class.h>
#include <port.h>
#include <stdio.h>

/* XXXXX This SHOULDN't be here, it's here to define O_RDONLY
 * and we want to use a different constant. eh?
*/
#include <fcntl.h>

#define DEBUG_ON

static FILE *debug_out = stderr;

#ifdef DEBUG_ON
static int _debug = 1;
#define DEBUG if(_debug)
#else
#define DEBUG if(0)
#endif


void XaServerShutdown(XaMasterConnection &serverConn) {

    // Make a little noise.
    DEBUG {
	fprintf(debug_out, "\nAtom Store at shutdown:\n");
	// serverConn.AtomCache().printOn(debug_out);
    }
}

void XaServerStartup(XaMasterConnection &serverConn) {

    // Make some noise ...
    DEBUG {
	fprintf(debug_out, "Digital Audio Server Initialization\n");
	// serverConn.AtomCache().printOn(debug_out);
    }


    
    // ... set up initial devices ...

    //
    // Today we do this by hand, .... tomorrow we'll 
    // do this automatically.
    //

    // Get the Device Class and if it's there start creating devices.
    XaClass *deviceClass = (XaClass*)serverConn.ClassDB().find(XaAdevice);
    if(deviceClass != NULL) {

	// Devices get intiailized from here:
	const char *deviceLibrary = "libdec_msbdevice.so";
 	
	// Get the tag for the new device, and create it.
	XaTag deviceTag = serverConn.NewTag();
	XaDevice *playDevice = (XaDevice*)deviceClass->Create(&serverConn,
						    deviceTag, XaAdevice,
						    NULL, 0);
	if(!playDevice) {
	    fprintf(stderr, "Unable to create a device object.\n");
	    return;
	}

	// Initialize and start up the device.
	if(playDevice->init(deviceLibrary) != XaEFailure) {
	    if(playDevice->Open(O_RDWR) != XaEFailure) {
		// This one is going to be the Default output buffer
		// that Port will "connect" to.
		// We tell port via this variable,
		// at least for now. The Correct thing
		// to do is to have class attributes here.
		XaPort::defaultOutputBuffer = deviceTag;
		DEBUG {
		    fprintf(debug_out, "Init/Open of device.\n");
		}
	    } else {
		fprintf(stderr, "Unable to open the device\n");
	    }
	} else {
	    fprintf(stderr, "Unable to initialize the device from: \"%s\"\n",
		             deviceLibrary);
	}
    } else {
	fprintf(stderr, "Unable to obtain Class: \"%s\"\n", XaNdevice);
    }

}
