/* $XConsortium: xatime.h /main/2 1996/12/30 16:34:50 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

/* Taken from AF3R1, Copyright 1993 by Digital Equipment Corporation
 */

#ifndef __XATIME_H
#define __XATIME_H

#ifdef __cplusplus

// Computation
// x - y
inline XaTime Difference(XaTime a, XaTime b)
    { return (int)a - (int)b; }
// a is earlier than b
inline XaBoolean Before(XaTime a, XaTime b)
    { return (Difference(a,  b) < 0); }
// a is later than b
inline XaBoolean After(XaTime a, XaTime b)
    { return (Difference(a,  b) > 0); }
// x is equal to or after a and before b
inline XaBoolean Between(XaTime a, XaTime x, XaTime b)
    { return (After(b, x) && !Before(x, a)); }

#else


/* definitions regarding Time arithmetic */

/* x - y */
#define DIFF(x, y) ((int) (((int) (x)) - ((int) (y))))

/* x is earlier than y */
#define BEFORE(x, y) (DIFF(x, y) < 0)
/* x is later than y */
#define AFTER(x, y) (DIFF(x, y) > 0)
/* x is equal to or after a and before b */
#define BETWEEN(a, x, b) (AFTER((b), (x)) && (!BEFORE((x), (a))))

/* if x is BEFORE time, x = time */
#define KEEPUP(x, time) if (BEFORE((x), (time))) (x) = (time)


#endif


#endif
