/* $XConsortium: transbuffs.h /main/4 1996/12/30 16:34:48 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __transbuffs_h
#define __transbuffs_h

// #include "buffer.h"
// #include "device.h"
#include <Xalib.h>
#include "intbuffer.h"
#include "ringbuffer.h"
#include "scheduler.h"
#include "cdevice.h"

class XaConnector;

/* Transfer buffer is a read/write delegate for Buffer objects. */
class XaTransferBuffer  {

protected:
    XaTransferBuffer() { parentConnector = NULL; }
    XaTransferBuffer(XaConnector *parent) : parentConnector(parent) {}

public:

    virtual ~XaTransferBuffer() {}
	
    virtual XaErrorCode GetData(XaTime minTime, XaTime maxTime,
				XaTime &startTime, XaTime &endTime) = 0;

    virtual XaErrorCode Read(XaTime atTime, XaTag refTime, 
			     XaAudioBuffer *&buffer, CARD32 bitsToRead, 
			     CARD8 &leftPad, CARD32 &bitsRead, 
			     XaTime &deviceTime) = 0;

    virtual XaErrorCode Write(XaTime atTime, XaTag refClock, 
			      XaAudioBuffer &buffer,
			      CARD32 bitsToWrite, 
			      CARD8 leftPad, CARD32 &bitsWritten,
			      XaTime &deviceTime) = 0;

    virtual XaErrorCode WriteTransfer(XaTime atTime, XaAtom refTime, 
			XaAudioBuffer *&buf, CARD32 bitsToRead, 
			CARD8 &leftPad, CARD32 &bitsRead, 
			XaTime deviceTime) = 0;

    virtual XaErrorCode ReadTransfer(XaTime atTime, XaAtom refTime, 
			XaAudioBuffer &buf, CARD32 bitsToWrite, 
			CARD8 leftPad, CARD32 &bitsWritten,
			XaTime deviceTime) = 0;

    
    virtual XaErrorCode RingBufConfigure(char **buf, XaTime length,
				    CARD32 nChannels, CARD32 sWidth,
				    XaTime transferSize, XaTime sampleLimit,
				    XaTime hardwareTransferLimit,
				    XaTime currentSample, XaAtom direction,
				    XaMixingBuffer *parent)
		    { return XaEFailure; }

protected:

    // XXXXX Not sure if this is a good idea.  Need a place to store the
    // device time returned from WriteTransfer and ReadTransfer.  Also need the
    // corresponding wall time.  This needs to be accessible by the XaDevice so
    // maybe it belongs in a different place. (pderr)
    XaTime _deviceTime;
    XaWallTime _deviceWallTime;

    XaConnector *parentConnector;
};

class XaPassThroughBuffer : public XaTransferBuffer {


public:
    
    XaPassThroughBuffer(XaObject * theDevice, void * theConnectID,
			DeviceWriteFunc write_func) :
	device(theDevice), connectID(theConnectID), _write_func(write_func) {};
	
    virtual ~XaPassThroughBuffer() {};

    virtual XaErrorCode GetData(XaTime minTime, XaTime maxTime,
				XaTime &startTime, XaTime &endTime);

    virtual XaErrorCode Read(XaTime atTime, XaTag refTime, 
			     XaAudioBuffer *&buffer, CARD32 bitsToRead, 
			     CARD8 &leftPad, CARD32 &bitsRead, 
			     XaTime &deviceTime);

    virtual XaErrorCode Write(XaTime atTime, XaTag refClock, 
			      XaAudioBuffer &buffer, CARD32 bitsToWrite, 
			      CARD8 leftPad, CARD32 &bitsWritten,
			      XaTime &deviceTime);

    virtual XaErrorCode WriteTransfer(XaTime atTime, XaAtom refTime, 
			XaAudioBuffer *&buf, CARD32 bitsToRead, 
			CARD8 &leftPad, CARD32 &bitsRead, 
			XaTime deviceTime);

    virtual XaErrorCode ReadTransfer(XaTime atTime, XaAtom refTime, 
			XaAudioBuffer &buf, CARD32 bitsToWrite, 
			CARD8 leftPad, CARD32 &bitsWritten,
			XaTime deviceTime);

protected:
    XaObject * device;
    void * connectID;
    DeviceWriteFunc _write_func;
};

class XaMixingBuffer : public XaTransferBuffer {

    friend class XaMixingConnector;

public:
    
    XaMixingBuffer() : ringBuffer(NULL) {}
    XaMixingBuffer(XaConnector *parent) : XaTransferBuffer(parent),
			ringBuffer(NULL) {}
	
    virtual ~XaMixingBuffer();
    
    virtual XaErrorCode GetData(XaTime minTime, XaTime maxTime,
				XaTime &startTime, XaTime &endTime);
    
    virtual XaErrorCode Read(XaTime atTime, XaTag refTime, 
			     XaAudioBuffer *&buffer, CARD32 bitsToRead, 
			     CARD8 &leftPad, CARD32 &bitsRead, 
			     XaTime &deviceTime);
    
    virtual XaErrorCode Write(XaTime atTime, XaTag refClock, 
			      XaAudioBuffer &buffer, CARD32 bitsToWrite, 
			      CARD8 leftPad, CARD32 &bitsWritten,
			      XaTime &deviceTime);
    
    
    virtual XaErrorCode WriteTransfer(XaTime atTime, XaAtom refTime, 
				      XaAudioBuffer *&buf,
				      CARD32 bitsToRead, 
				      CARD8 &leftPad, CARD32 &bitsRead, 
				      XaTime deviceTime);
    
    // I'm tired of dealing with bits, so I'm overloading WriteTransfer
    virtual XaErrorCode WriteTransfer(XaTime atTime, XaAtom refTime, 
				      char *&buf, CARD32 samplesToRead, 
				      CARD32 &samplesRead, 
				      XaTime deviceTime);
    
    XaErrorCode WriteThrough(XaTime atTime, XaTag refClock, 
				  char *buffer, CARD32 bitsToWrite, 
				  CARD8 leftPad, CARD32 &bitsWritten,
				  XaTime &deviceTime);

    virtual XaErrorCode ReadTransfer(XaTime atTime, XaAtom refTime, 
				     XaAudioBuffer &buf,
				     CARD32 bitsToWrite, 
				     CARD8 leftPad, CARD32 &bitsWritten,
				     XaTime deviceTime);
    
    virtual XaErrorCode RingBufConfigure(char **buf, XaTime length,
					 CARD32 nChannels, CARD32 sWidth,
					 XaTime transferSize,
					 XaTime sampleLimit,
					 XaTime hardwareTransferLimit,
					 XaTime currentSample,
					 XaAtom direction);
    
protected:
    
    XaRingBuffer *ringBuffer;
    
    
};

#endif
