/* $XConsortium: transbuffs.cc /main/8 1996/12/30 16:34:45 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/


#include "transbuffs.h"
#include "connectors.h"
#include "element.h"


XaErrorCode XaPassThroughBuffer::GetData(XaTime minTime, XaTime maxTime,
					 XaTime &startTime, XaTime &endTime) {

    XaErrorCode e = XaESuccess;

    return e;
}

XaErrorCode XaPassThroughBuffer::Read(XaTime atTime, XaTag refTime, 
				      XaAudioBuffer *&buffer,
				      CARD32 bitsToRead, 
				      CARD8 &leftPad, CARD32 &bitsRead, 
				      XaTime &deviceTime) {
    XaErrorCode e = XaESuccess;

    return e;

}

XaErrorCode XaPassThroughBuffer::Write(XaTime atTime, XaTag refClock, 
				       XaAudioBuffer &buffer,
				       CARD32 bitsToWrite, 
				       CARD8 leftPad, CARD32 &bitsWritten,
				       XaTime &deviceTime) {
    return _write_func(device, connectID, atTime, refClock,
		       (char *)buffer.GetBuffer(), buffer.GetSize() * 8, leftPad,
		       &bitsWritten, &deviceTime);
}

XaErrorCode XaPassThroughBuffer::WriteTransfer(XaTime atTime, XaAtom refTime, 
					       XaAudioBuffer *&buf,
					       CARD32 bitsToRead, 
					       CARD8 &leftPad,
					       CARD32 &bitsRead, 
					       XaTime deviceTime) {

    // This should not ever actually do anything, all data should have
    // already been transferred.

    bitsRead = 0;

    XaErrorCode e = XaESuccess;

    return e;

}

XaErrorCode XaPassThroughBuffer::ReadTransfer(XaTime atTime, XaAtom refTime, 
					      XaAudioBuffer &buf,
					      CARD32 bitsToWrite, 
					      CARD8 leftPad,
					      CARD32 &bitsWritten,
					      XaTime deviceTime) {
    

    XaErrorCode e = XaESuccess;

    return e;

}



////////////////////////
// 
// MixingBuffer
//
//////////////////////

//XaMixingBuffer::XaMixingBuffer()
//{
//    ringBuffer = NULL;
//}

XaMixingBuffer::~XaMixingBuffer()
{
    // XXXXXXXXXXXXXXXXXX
}

XaErrorCode XaMixingBuffer::GetData(XaTime minTime, XaTime maxTime,
				XaTime &startTime, XaTime &endTime)
{
// What's this for???
    return XaEUnimplemented;
}

XaErrorCode XaMixingBuffer::Read(XaTime atTime, XaTag refTime, 
				 XaAudioBuffer *&buffer, CARD32 bitsToRead, 
				 CARD8 &leftPad, CARD32 &bitsRead, 
				 XaTime &deviceTime)
{
    return XaEUnimplemented;
}

XaErrorCode XaMixingBuffer::Write(XaTime atTime, XaTag refClock, 
				  XaAudioBuffer &buffer, CARD32 bitsToWrite, 
				  CARD8 leftPad, CARD32 &bitsWritten,
				  XaTime &deviceTime)
{
    XaErrorCode returnCode;
    XaBoolean   preempt = XaFalse; // XXXXX should come from some attribute!!

    if (!ringBuffer)
	return XaEServerInternal;

    if (leftPad != 0)
	return XaEValue;	// can't deal with this

    buffer.Get();
    char *buff = (char *)(buffer.GetBuffer());

    CARD32 bitsPerFrame
		= parentConnector->GetElement()->FormatCache().bitsPerFrame;

    XaTime samplesToWrite = bitsToWrite/bitsPerFrame;
    XaTime samplesWritten;

    returnCode = ringBuffer->Write(atTime, refClock, preempt, buff,
				    samplesToWrite, &samplesWritten);

    buffer.Release();
    bitsWritten = samplesWritten * bitsPerFrame;

    return returnCode;
}

XaErrorCode XaMixingBuffer::WriteThrough(XaTime atTime, XaTag refClock, 
				  char *buffer, CARD32 bitsToWrite, 
				  CARD8 leftPad, CARD32 &bitsWritten,
				  XaTime &deviceTime)
{
    // refClock should always be XaAdeviceTime

    if (!parentConnector || !parentConnector->writethroughFunction)
	return XaEFailure;

    return parentConnector->writethroughFunction(this, NULL, atTime, refClock,
					    buffer, bitsToWrite, leftPad,
					    &bitsWritten, &deviceTime);

}

XaErrorCode XaMixingBuffer::WriteTransfer(XaTime atTime, XaAtom refTime, 
				    XaAudioBuffer *&buf, CARD32 bitsToRead, 
				    CARD8 &leftPad, CARD32 &bitsRead, 
				    XaTime deviceTime)
{

    return XaEUnimplemented;
}
XaErrorCode XaMixingBuffer::WriteTransfer(XaTime atTime, XaAtom refTime, 
				    char *&buf,
				    CARD32 samplesToRead, 
				    CARD32 &samplesRead, 
				    XaTime deviceTime)
{

    if (!ringBuffer) return XaEServerInternal;

    // The device provided us this time, stash it here and also the current
    // wall time.
    // XXXX need to get this into an accessible location, if this isn't it.
    _deviceTime = deviceTime;
    _deviceWallTime.Now();


    return ringBuffer->WriteTransfer(atTime, refTime, &buf, samplesToRead,
					(XaTime *)&samplesRead);
}
XaErrorCode XaMixingBuffer::ReadTransfer(XaTime atTime, XaAtom refTime, 
				    XaAudioBuffer &buf, CARD32 bitsToWrite, 
				    CARD8 leftPad, CARD32 &bitsWritten,
				    XaTime deviceTime)
{
    return XaEUnimplemented;

}

XaErrorCode XaMixingBuffer::RingBufConfigure(char **buf,
					XaTime length,
					CARD32 numChannels, CARD32 sampleWidth,
					XaTime transferSize, XaTime sampleLimit,
					XaTime hardwareTransferLimit,
					XaTime currentSample, XaAtom direction)
{
    CARD32 size = ((length * numChannels * sampleWidth) + 7) / 8;

    // If a buffer is passed in, use it for the ringBuffer.   This allows
    // device-specific code to provide the buffer.

    if (*buf && ringBuffer)
	ringBuffer->InternalBuffer()->Release();

    if (!ringBuffer)
    {
	ringBuffer = new XaRingBuffer(new XaInternalBuffer(size, *buf),
				0, length,
				parentConnector->GetElement()->FormatCache(),
				direction);
    }
    else if (size > ringBuffer->buffer->GetSize())
    {
	ringBuffer->InternalBuffer()->Release();
	ringBuffer->buffer = new XaInternalBuffer(size, *buf);
    }

    *buf = (char *)ringBuffer->InternalBuffer()->GetBuffer();
    return (ringBuffer->Configure(length, numChannels, sampleWidth,
			  parentConnector->GetElement()->FormatCache().encoding,
				    transferSize, sampleLimit,
				    hardwareTransferLimit, currentSample,
				    this));
}


