/* $XConsortium: diatest.cc /main/4 1996/12/30 16:34:34 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#include <stdlib.h>
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>

#include "object.h"
#include "class.h"
#include "device.h"
#include "port.h"
#include "fileio.h"
#include <Xa/atomdefs.h>

#include <clientconn.h>
XaMasterConnection masterConnection;
XaErrorCode XaCreateWellKnownClasses(XaConnection *conn);

// file: diatest.cc
// tabs = 4

/*
 * 
*/

#ifdef NEVER
void DiaTest1 (int argc, char **argv)
{
    // Initial Data.

    XaFile      *sunfile;
    XaDevice    *device;
    unsigned     sample_rate;
    unsigned     samples_per_unit;
    unsigned     bytes_per_unit;
    unsigned     channels;
    unsigned     encoding;
    unsigned     data_size;
    unsigned     hdr_size;
    unsigned     endian;

    char         buf[1024];
    char        *data;
    int          status; 
    	         nbytes;
    
    int          buffSizeSecs = 1; /* in seconds */
    int          buffSizeBytes;
    int          bytes_played;
    int          bytes_played_total;
    int          read_bytes;
    char        *file_name;
    char        *libName = "libsundevice.so";
    XaErrorCode  err;
    
//
// Create a device object.
//
    device = new XaDevice(libName);
    if (!device) {
      fprintf (stderr, "Failed to create an XaDevice object\n");
      return;
    }
//
// Add the device attributes to the object.
//
    err = device->AddAttribute (XaAformatNumChannels, XaTtag);
    err = device->AddAttribute (XaAformatEndian, XaTtag);
    err = device->AddAttribute (XaAformatSampleWidth, XaTtag);
    err = device->AddAttribute (XaAformatSampleRate, XaTtag);
    err = device->AddAttribute (XaAformatEncoding, XaTtag);
//
// Open the device
// This also initializes the device.
//
    err = device->Open(O_RDWR);
    if (err == XA_FAILURE) {
      fprintf (stderr, " **Could not open device**\n");
      return;
    }
	
//
// Try to open a test audio file to play.
//
    file_name = argv[1];
    sunfile = XaFile::openFileObject (file_name);
    
    if (sunfile == NULL) {
      fprintf (stderr, "**Could not open test file **\n");
      return;
    }
    
    err = sunfile->getAttribute (AUDIO_NCHANNELS, (void *&)channels);
    err = sunfile->getAttribute (AUDIO_SAMPLE_RATE, (void *&)sample_rate);
    err = sunfile->getAttribute (AUDIO_SAMPLES_PER_UNIT, (void *&)samples_per_unit);
    err = sunfile->getAttribute (AUDIO_BYTES_PER_UNIT, (void *&)bytes_per_unit);
    err = sunfile->getAttribute (AUDIO_ENCODING, (void *&)encoding);
    err = sunfile->getAttribute (AUDIO_DATA_SIZE, (void *&)data_size);
    err = sunfile->getAttribute (AUDIO_HEADER_SIZE, (void *&)hdr_size);
    err = sunfile->getAttribute (AUDIO_ENDIAN, (void *&)endian);

//
// Set the attributes on the device.
//
    err = device->SetAttribute(XaAformatNumChannels, (void *)channels,
			 XaAformatSampleRate, (void *)sample_rate,
			 XaAformatSampleWidth, (void *)(bytes_per_unit * 8),
			 XaAformatEncoding, (void *)encoding, NULL);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to set device attributes.\n");
    }
    /* Create the buffer */
    buffSizeBytes = sample_rate * buffSizeSecs *
                    samples_per_unit * bytes_per_unit;
    data = (char *)malloc (buffSizeBytes);
    
    /* play the file */
    bytes_played_total = 0;
    do {
      read_bytes = sunfile->Read(data, buffSizeBytes);
      bytes_played = device->Write(data, read_bytes );
      bytes_played_total += bytes_played;
      if( bytes_played != read_bytes) 
	fprintf (stderr, " **Read and Written bytes disagreed**\n");
    } while (read_bytes != 0 );
    
    /* Drain device. */
    device->drain();
    
    if (data)
      free (data);
    
    sunfile->Close ();

    device->Close ();
}

void DiaTest2 (int argc, char **argv)
{
    extern XaObject *XaCreateObject (XaConnection *, XaTag, XaTag, XaTag,
				     XaAttributeCBData*, CARD32);
    extern XaErrorCode XaCreateWellKnownClasses(XaConnection *conn);

    XaAttributeCBData    attrs[10];
    XaMasterConnection  *conn;
    XaDevice 	 	*device;
    XaClass		*classdev;
    XaErrorCode		 err;
    char        	*file_name;
    char        	*libName = "libsundevice.so";
    XaFile      *sunfile;
    unsigned     sample_rate;
    unsigned     samples_per_unit;
    unsigned     bytes_per_unit;
    unsigned     channels;
    unsigned     encoding;
    unsigned     data_size;
    unsigned     hdr_size;
    unsigned     endian;
    int          buffSizeSecs = 1; /* in seconds */
    int          buffSizeBytes;
    int          bytes_played;
    int          bytes_played_total;
    int          read_bytes;

    char         buf[1024];
    char        *data = NULL;
    int          status; 
    const int	 gain_value = 125;

//
// Create a master connecton
//
    conn = new XaMasterConnection();
    XaCreateWellKnownClasses(conn);

//
// Create a class device obj.
//
    classdev = (XaClass *)conn->ClassDB().find(XaTdevice);
    if (classdev == NULL) {
      fprintf (stderr, "Unable to create device class.\n");
      return;
    }
//
// Create a device object
//
    device = (XaDevice *)XaCreateObject (conn, XaTdevice, conn->GetTag(),
					XaTnone, NULL, 0);
    //device = (XaDevice *)classdev->Create (conn, XaTdevice, conn->GetTag(),
//					XaTnone, NULL, 0);

//
// Add the device attributes to the object.
//
//  err = device->AddAttribute (XaAformatNumChannels, XaTtag);
//  err = device->AddAttribute (XaAformatEndian, XaTtag);
//  err = device->AddAttribute (XaAformatSampleWidth, XaTtag);
//  err = device->AddAttribute (XaAformatSampleRate, XaTtag);
//  err = device->AddAttribute (XaAformatEncoding, XaTtag);
//
// Open the device
// This also initializes the device.
//
    err = device->init (libName);
    if (err == XaEFailure) {
      fprintf (stderr, " **Could not open device**\n");
      return;
    }
    err = device->Open(O_RDWR);
    if (err == XA_FAILURE) {
      fprintf (stderr, " **Could not open device**\n");
      return;
    }
	
//
// Try to open a test audio file to play.
//
    file_name = argv[1];
    sunfile = XaFile::openFileObject (file_name);
    
    if (sunfile == NULL) {
      fprintf (stderr, "**Could not open test file **\n");
      return;
    }
    
    err = sunfile->getAttribute (AUDIO_NCHANNELS, (void *&)channels);
    err = sunfile->getAttribute (AUDIO_SAMPLE_RATE, (void *&)sample_rate);
    err = sunfile->getAttribute (AUDIO_SAMPLES_PER_UNIT, (void *&)samples_per_unit);
    err = sunfile->getAttribute (AUDIO_BYTES_PER_UNIT, (void *&)bytes_per_unit);
    err = sunfile->getAttribute (AUDIO_ENCODING, (void *&)encoding);
    err = sunfile->getAttribute (AUDIO_DATA_SIZE, (void *&)data_size);
    err = sunfile->getAttribute (AUDIO_HEADER_SIZE, (void *&)hdr_size);
    err = sunfile->getAttribute (AUDIO_ENDIAN, (void *&)endian);

//
// Set the attributes on the device.
//
    attrs[0].name = XaAdeviceGain; attrs[0].value = (void *)gain_value;
    //attrs[1].name = XaAformatSampleRate; attrs[1].value = (void *)sample_rate;
    //attrs[2].name = XaAformatSampleWidth; attrs[2].value = (void *)(bytes_per_unit * 8);
    //attrs[3].name = XaAformatEncoding; attrs[3].value = (void *)encoding;
    err = device->SetAttribute(conn, &attrs[0]);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to set device attributes.\n");
    }
//
// Get the attribute we just set.
//
    err = device->GetAttribute(conn, &attrs[0]);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to get device attributes.\n");
    }
    if ((int)attrs[0].value != gain_value)
       fprintf (stderr, "Failed to get device attributes.\n");
//
// Set attributes on the buffer since device is a buffer.
//
    attrs[0].name = XaAbufferFormat; attrs[0].value = (void *)XaTencodeUlaw;
    err = device->SetAttribute(conn, &attrs[0]);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to set device attributes.\n");
    }
#ifdef NEVER
    /* Create the buffer */
    buffSizeBytes = sample_rate * buffSizeSecs *
                    samples_per_unit * bytes_per_unit;
    data = (char *)malloc (buffSizeBytes);
    
    /* play the file */
    bytes_played_total = 0;
    do {
      read_bytes = sunfile->Read(data, buffSizeBytes);
      bytes_played = device->Write(data, read_bytes );
      bytes_played_total += bytes_played;
      if( bytes_played != read_bytes) 
	fprintf (stderr, " **Read and Written bytes disagreed**\n");
    } while (read_bytes != 0 );
    
    /* Drain device. */
    device->drain();
    
    if (data)
      free (data);
    
#endif
    sunfile->Close ();

    device->Close ();
}
#endif

void DiaTest3 (int argc, char **argv)
{
    extern XaObject *XaCreateObject (XaConnection *, XaTag, XaTag, XaTag,
				     XaAttributeCBData*, CARD32);
    extern XaErrorCode XaCreateWellKnownClasses(XaConnection *conn);

    XaAttributeCBData    attrs[10];
    XaMasterConnection  *conn;
    XaDevice 	 	*device;
    XaPort   	 	*port;
    XaObject   	 	*format;
    XaClass		*classdev, *classport;
    XaErrorCode		 err;
    char        	*file_name;
    char        	*libName = "libsundevice.so";
    XaTag		 deviceTag, formatTag;
    XaFile      *sunfile;
    unsigned     sample_rate;
    unsigned     samples_per_unit;
    unsigned     bytes_per_unit;
    unsigned     channels;
    unsigned     encoding;
    unsigned     data_size;
    unsigned     hdr_size;
    unsigned     endian;
    int          buffSizeSecs = 1; /* in seconds */
    int          buffSizeBytes;
    int          bytes_played;
    int          bytes_played_total;
    int          read_bytes;

    //char         buf[1024];
    //char        *data = NULL;
    int          status; 
    const int	 gain_value = 125;
    CARD32	 numWritten;
    XaInternalBuffer *buffer = new XaInternalBuffer(88201);
    void             *buf;

//
// Create a master connecton
//
    conn = new XaMasterConnection();
    XaCreateWellKnownClasses(conn);
//
// Build device: 
//
    deviceTag = conn->GetTag();
//
// Get the class device obj.
//
    classdev = (XaClass *)conn->ClassDB().find(XaAdevice);
    if (classdev == NULL) {
      fprintf (stderr, "Unable to get device class.\n");
      return;
    }
//
// Create a device object
//
    device = (XaDevice *)classdev->Create (conn, deviceTag, XaAdevice, NULL, 0);
    if (!device) {
      fprintf (stderr, "Unable to create device class object.\n");
      return;
    }
//
// Set the default output buffer 
//
    XaPort::defaultOutputBuffer = deviceTag;

//
// Get the port class obj.
// 
    classport = (XaClass *)conn->ClassDB().find(XaAport);
    if (classport == NULL) {
      fprintf (stderr, "Unable to get the port class.\n");
      return;
    }
//
// Create a port object.
//
    port = (XaPort *)classport->Create (conn, conn->GetTag(), XaAport, NULL, 0);
    if (port == NULL) {
      fprintf (stderr, "Unable to create port class object .\n");
      return;
    }
   
//
// Open the device
// This also initializes the device.
//
    err = device->init (libName);
    if (err == XaEFailure) {
      fprintf (stderr, " **Could not open device**\n");
      return;
    }
    err = device->Open(O_RDWR);
    if (err == XA_FAILURE) {
      fprintf (stderr, " **Could not open device**\n");
      return;
    }
	
//
// Try to open a test audio file to play.
//
    file_name = argv[1];
/*
    sunfile = XaFile::openFileObject (file_name);
    
    if (sunfile == NULL) {
      fprintf (stderr, "**Could not open test file **\n");
      return;
    }
    
    err = sunfile->getAttribute (AUDIO_NCHANNELS, (void *&)channels);
    err = sunfile->getAttribute (AUDIO_SAMPLE_RATE, (void *&)sample_rate);
    err = sunfile->getAttribute (AUDIO_SAMPLES_PER_UNIT, (void *&)samples_per_unit);
    err = sunfile->getAttribute (AUDIO_BYTES_PER_UNIT, (void *&)bytes_per_unit);
    err = sunfile->getAttribute (AUDIO_ENCODING, (void *&)encoding);
    err = sunfile->getAttribute (AUDIO_DATA_SIZE, (void *&)data_size);
    err = sunfile->getAttribute (AUDIO_HEADER_SIZE, (void *&)hdr_size);
    err = sunfile->getAttribute (AUDIO_ENDIAN, (void *&)endian);
*/

//
// Create a format object
//
    formatTag = conn->GetTag();
    format = (XaObject *)XaCreateObject (conn, XaAformat, formatTag,
					XaTnone, NULL, 0);
    //format = (XaFormat *)classfmt->Create (conn, XaTformat, formatTag, NULL, 0);
    if (!format) {
      fprintf (stderr, "Unable to create format object.\n");
      return;
    }

//
// Set the attributes on the format from the file.
//
channels = 1;
sample_rate = 8000;
encoding = XaAencodeUlaw;
bytes_per_unit = 1;
    attrs[0].name = XaAnumChannels; attrs[0].value = (void *)channels;
    attrs[1].name = XaAsampleRate; attrs[1].value = (void *)sample_rate;
    attrs[2].name = XaAencoding; attrs[2].value = (void *)encoding;
    attrs[3].name = XaAbitsPerSample; attrs[3].value = (void *)(bytes_per_unit * 8);
    attrs[4].name = XaAbigEndian; attrs[4].value = (void *)XaTrue;
    err = format->SetAttributes (conn, &attrs[0], 5);
    if (err == XaEFailure) {
      fprintf (stderr, "Unable to set format attributes on format object.\n");
      return;
    }

//
// Set this format object onto the port...
//
    attrs[0].name = XaAformat; attrs[0].value = (void *)formatTag;
    err = port->SetAttribute (conn, &attrs[0]); 
    if (err == XaEFailure) {
      fprintf (stderr, "Unable to format on port object.\n");
      return;
    }
//
// Set the attributes on the device
//
    attrs[0].name = XaAgain; attrs[0].value = (void *)gain_value;
    err = device->SetAttribute(conn, &attrs[0]);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to set device attributes.\n");
    }
//
// Get the attribute we just set.
//
    err = device->GetAttribute(conn, &attrs[0]);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to get device attributes.\n");
    }
    if ((int)attrs[0].value != gain_value)
       fprintf (stderr, "Failed to get device attributes.\n");
//
// Test for inherited attributes.
// Set attributes on the buffer since device is a buffer.
//
/*
    attrs[0].name = XaAbufferFormat; attrs[0].value = (void *)XaTencodeUlaw;
    err = device->SetAttribute(conn, &attrs[0]);
    if (err == XaEFailure) {
       fprintf (stderr, "Failed to set device attributes.\n");
    }
*/

    /* Create the buffer */
    buffSizeBytes = sample_rate * buffSizeSecs *
                    samples_per_unit * bytes_per_unit;
    //data = (char *)malloc (buffSizeBytes);
    
    /* play the file */
    bytes_played_total = 0;
    do {
      buf = buffer->GetBuffer();
      //read_bytes = sunfile->Read((char *)buf, buffSizeBytes);
      buffer->Get();  // bump the refcount up while installing the task

      //err = port->Write(0, 0, buffer, read_bytes * 8, 0, &numWritten);
      bytes_played = numWritten / 8;
      bytes_played_total += bytes_played;
      if( bytes_played != read_bytes) 
	fprintf (stderr, " **Read and Written bytes disagreed**\n");
    } while (read_bytes != 0 );
    
    /* Drain device. */
    device->drain();
    
    //if (data)
      //free (data);
    
    sunfile->Close ();

    device->Close ();
}

main (int argc, char **argv)
{

    if (argc < 2) {
      fprintf (stderr, "Usage:  diatest [sunaudiofile]\n");
      exit (0);
    }

//    DiaTest1 (argc, argv);
//    DiaTest2 (argc, argv);
    DiaTest3 (argc, argv);

} 
