/* $XConsortium: scheduler.h /main/5 1996/12/30 16:34:18 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __scheduler_h
#define __scheduler_h

#include <X11/Xmd.h>
#include "object.h"
#include "connection.h"
#include <sys/types.h>
#ifdef hpux
#include <time.h>
#else
#ifdef sco
// SCO sys/time.h not C++ sanitized
extern "C" {
#include <sys/time.h>
}
#else
#include <sys/time.h>
#endif // sco
#endif // hpux
#include <poll.h>

const int   XaMAX_FD_TASKS = 200;

/*
    ---------------------------------------------------------------------
    Support classes/superclasses
*/

/* XXX mw: This shouldn't be here, but since only the scheduler and
   immediate users of the scheduler are using it, I thought I'd put
   it in here. */

const int NUM_INITIAL_ARRAY_ELEMENTS = 8;

class XaInternalOrderedCltn
{
private:
    void            **buf;
    int             bufSize;   /* allocated chunk of pointers */
    int             arraySize; /* number of objects stored */
protected:
    void            GrowArray(void); /* double the allocated size */
    void            MoveElements(int start, int howMany, int newStart);
public:
                    XaInternalOrderedCltn(void);
                    ~XaInternalOrderedCltn(void);

    void            Add(void *elem, int beforeWhich);
    void            Append(void *elem) { Add(elem, arraySize+1); }
    void *          At(int whichElem) const { return buf[whichElem]; }
    int             GetSize(void) const { return arraySize; }
    virtual int     Find(void *elem) const;
    void            Delete(void *elem);
    void *      AtDelete(int whichElem);

    // Invariant checker (debugging aid)
    void            Invariant(void) const;
};


/*
    ---------------------------------------------------------------------
    Scheduler specific classes
*/

/* XaWallTime is a positive time value. */
class XaWallTime /* : XaTime? in the future */
{
private:
    struct timeval  tv;

    static void     Add(const XaWallTime& t1, const XaWallTime& t2,
			XaWallTime& result);
    static void     Subtract(const XaWallTime& t1, const XaWallTime& t2,
			     XaWallTime& result);

public:
    /* no virtuals here, in order to make this bitwise equal
       to a struct timeval */

                    XaWallTime(int sec, int usec)
		        { tv.tv_sec = sec; tv.tv_usec = usec; }
                    XaWallTime(void)
		        { tv.tv_sec = 0; tv.tv_usec = 0; }
                    XaWallTime(int msec)
		        { tv.tv_sec = msec / 1000; tv.tv_usec = msec % 1000; }
                    
    void            Now() { gettimeofday(&tv, (struct timezone *) NULL); }
    void            Set(const unsigned long seconds, const long usec);
    void            Get(unsigned long& seconds, long& usec);

    /* Overloaded operators */
    XaWallTime      operator + (const XaWallTime& t2) const;
    XaWallTime&     operator += (const XaWallTime& t2);

    /* Subtraction pins at 0 (no negative time values) */
    XaWallTime      operator - (const XaWallTime& t2) const;
    XaWallTime&     operator -= (const XaWallTime& t2);

    /* Comparison operators */

    int             operator == (const XaWallTime& t2) const;
    int             operator != (const XaWallTime& t2) const;

    int             operator < (const XaWallTime& t2) const;
    int             operator <= (const XaWallTime& t2) const;

    int             operator > (const XaWallTime& t2) const;
    int             operator >= (const XaWallTime& t2) const;

    /* Typecast to int (milliseconds) */
                    operator int(void) const;

    /* Invariant check */
    void            Invariant(void) const;
};

class XaTask;

typedef void    (*XaTaskProc)(XaTask *task, void *taskInfo);

// A task is a procedure to be called when some specified condition
// has been met.
class XaTask
{
protected:
    XaTaskProc      serviceProc;
    void *          userData;

    friend class    XaScheduler;

    virtual Bool    HasFD(void) const;

public:
                    XaTask(XaTaskProc proc, void *userData);
    void            Run(void) { (*serviceProc)(this, userData); }

    void            Invariant(void) const;
};

// A file descriptor that the scheduler waits on.
class XaFileTask : public XaTask
{
    friend class    XaScheduler;

    int		    fd;         // POSIX file descriptor

protected:

    virtual Bool    HasFD(void) const;
    int		    GetFD(void) const {return fd;}

public:
		    XaFileTask(XaTaskProc proc, void *userData, int fd);

    void            Invariant(void) const;
};

class XaTimedTask : public XaTask
{
    XaWallTime	    when;
    // XaDevice	    clock;

protected:
    friend class    XaScheduler;
    virtual Bool    HasFD(void) const;

public:
//		    XaTimedTask(XaTaskProc what, void *userData, 
//			        const XaTime& when, XaDevice& whichClock);
		    XaTimedTask(XaTaskProc what, void *userData, 
			        const XaWallTime& when);
    const XaWallTime&
	            GetTime(void) const { return when; }
//    void	    Reschedule(const XaTime& when, XaDevice& whichClock);
    void	    Reschedule(const XaWallTime& when);

    void            Invariant(void) const;
};

// need in a separate file
class XaInternalOrderedCltn;

/* Marker for end of ready fd list */
const int       XaEND_FILE_TASKS_READY = -1;
const int       XA_SCHED_TASK_EXCEPTION = -99;
const int       XA_SCHED_NO_EXCEPTION = 0;

// Main scheduling engine in X Audio server
class XaScheduler
{
    XaInternalOrderedCltn	    *fileTaskList;
    XaInternalOrderedCltn	    *timedTaskList;
    // XaInternalOrderedCltn	    *blockTaskList;
    // XaInternalOrderedCltn	    *unblockTaskList;

    /* XXX implementation specific, this should be in a subclass. */
    struct pollfd   pollList[XaMAX_FD_TASKS];

    /* Indicator for readiness of file tasks */
    int             readyList[XaMAX_FD_TASKS+1];
    int             nextReady;

    /* Indicator for readiness of timed tasks */
    int             timedTaskReady;
    
    /* members that the server in general will be interested in */
public:
    int             exception;
    

protected:
    void            ClearReadyIndexList(void);
    
    int             NextReadyIndex(void);
			 
    
    int   	    NextTaskTimeOffset(void) const;
    void            ClearPendingTasks(void);

    XaTask*         NextReadyTimedTask(void);
    XaTask*         NextReadyFileTask(void);
    XaTask*	    NextReadyTask(void);

    int             WaitForReadyTask(void);

    XaScheduler();

    friend XaScheduler& Scheduler(void);
    
public:

    /*
        The various Add* functions set up the correct fds/tasks needed
        to ensure proper operation.
    */
    void	    AddTask(XaTask& task);
    void	    RemoveTask(XaTask& task);

    // XXX Not sure if we need these.
/*
    void            AddBlockTask(XaTask& task);
    void            RemoveBlockTask(XaTask& task);
    
    void            AddUnblockTask(XaTask& task);
    void            RemoveUnblockTask(XaTask& task);
*/
    
    //void	    AddPort(XaPort& newPort);

    void	    RunTimedTasks();

    inline void     RaiseException(void) { exception = XA_SCHED_TASK_EXCEPTION; }
    inline void     ClearException(void) { exception = XA_SCHED_NO_EXCEPTION; }
    
    void	    Run(void);

    void            Invariant(void) const;
};

XaScheduler&        Scheduler(void);

#endif // __scheduler_h




