/* $XConsortium: port.h /main/11 1996/12/30 16:33:59 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

/*
   An XaPort is a conduit of data between a client and a device, or between
   two devices.
*/
#ifndef __port_h
#define __port_h

#include <Xa/Xalib.h>
#include "object.h"
#include "device.h"
#include "buffer.h"
#include "intbuffer.h"
#include "scheduler.h"
#include "transbuffs.h"

/*
    ---------------------------------------------------------------------
    Support classes/superclasses
*/


/*
    ---------------------------------------------------------------------
    Port class
*/

class XaConnection;
class XaClass;
class XaElement;

class XaPort : public XaBuffer {

public:
    static XaErrorCode XaPortCreateCB(XaObject *obj, XaAttributeCBData *data,
				      CARD32 count);
    static XaErrorCode XaPortDestroyCB(XaObject *obj);

#ifdef NEVER
    XaPort(XaConnection *, XaClass *, XaTag refTag, XaTag name,
	   BOOL continuous, BOOL ordered,
	   XaFormat *fmt,
	   XaDevice *inputBuffer, XaDevice *outputBuffer,
	   XaTag syncPolicy,
	   XaTag overflowAction, XaTag underflowAction);
#endif
    
    XaPort(XaConnection *conn, XaClass *cl, XaTag objectTag,
	   XaTag classTag, XaTag nameTag);
    XaPort(void);

    ~XaPort();

    
#ifdef oldReadWrite
    
    // Read sample bits from the port
    XaErrorCode Read(XaTime atTime, XaTag refClock, XaInternalBuffer *buffer, 
                    CARD32 bitsToRead, CARD8 *leftPad, CARD32 *bitsRead);

    // Write sample bits to the port
    XaErrorCode Write(XaTime atTime, XaTag refClock, XaInternalBuffer *buffer,
		      CARD32 bitsToWrite, CARD8 leftPad, CARD32 *bitsWritten);
#endif
    
    void Drain(void); // drains output buffer if set

    //
    // Here temporarily for testing until we can
    // set attributes on a class (XaNdefault)
    static XaTag defaultInputBuffer;
    static XaTag defaultOutputBuffer;

    //
    // Data Transfer
    //
    XaErrorCode PutData(XaTime minTime, XaTime maxTime,
			XaTime *startTime, XaTime *endTime);

    XaErrorCode GetData(XaTime minTime, XaTime maxTime,
			XaTime &startTime, XaTime &endTime);

    // Read sample bits from the port
    XaErrorCode Read(XaTime atTime, XaTag refClock, 
		     XaInternalBuffer *&buffer, CARD32 bitsToRead, 
		     CARD8 &leftPad, CARD32 &bitsRead,
		     XaTime &deviceTime);

    // Write sample bits to the port
    virtual XaErrorCode Write(XaTime atTime, XaTag refClock, 
			      XaInternalBuffer &buffer,
			      CARD32 bitsToWrite, CARD8 leftPad,
			      CARD32 &bitsWritten, XaTime &deviceTime);

    // Move data in and out of the device.
    virtual XaErrorCode WriteTransfer(XaTime atTime, XaAtom refTime,
				      CARD32 bitsToWrite, CARD32 &bitsWritten,
				      XaTime &deviceTime);

    virtual XaErrorCode ReadTransfer(XaTime atTime, XaAtom refTime, 
			     CARD32 bitsToRead,  CARD32 &bitsWritten,
			     XaTime &deviceTime);

    XaBoolean OutputRunning() { return outputRunning; }
    XaBoolean InputRunning() { return inputRunning; }
    XaTime LatestSample() { return audioData.LatestSample(); }
    XaTime EarliestSample() { return audioData.EarliestSample(); }

protected:

    static void bufferSetCB(void *obj, XaAttributeCBData *cbd);
    static void formatSetCB(void *obj, XaAttributeCBData *cbd);
    static void runSetCB(void *obj, XaAttributeCBData *cbd);
    static void inputTimestampGetCB(void *obj, XaAttributeCBData *cbd);
    static void inputBufferTimestampGetCB(void *obj, XaAttributeCBData *cbd);
    static void outputTimestampGetCB(void *obj, XaAttributeCBData *cbd);
    static void outputBufferTimestampGetCB(void *obj, XaAttributeCBData *cbd);


    //
    // Local storage/caching of various objects.
    //

    // input
    XaElement *inputBuffer;
    XaTransferBuffer *readDelegate;
    
    // output
    XaElement *outputBuffer;
    XaTransferBuffer *writeDelegate;

    // Format
    XaFormat *format;
    
    // Local Buffer of data objects
    XaAudioBufferCltn audioData;

    // Latest port time of most recent read/write request
    XaTime _lastAccessTime;
    XaTime lastTransferredSample;

    XaTime inputTimeOffset;
    XaTime outputTimeOffset;

    XaBoolean outputRunning;
    XaBoolean inputRunning;

    XaBoolean firstOutputWritten;

    float inputTimeFactor;
    float outputTimeFactor;
    
    
#ifdef __DECCXX
 private:
#endif

    // Local only methods for manipulating things. 
    //
    XaTime resolveToLocalTime(XaTime atTime, XaTag refClock);
    XaTime bitsToTime(CARD32 durationInBits);
    CARD32 timeToBits(XaTime duration);
    XaTime TranslateToPortTime(XaTime elementTime, XaTag refTime,
				    XaAtom direction);
    XaTime TranslateToElementTime(XaTime portTime, XaTag refTime,
					XaAtom direction);
    
    XaBoolean inVolatileZone(XaTime atTime, XaTime duration, XaAtom direction,
			    XaTime &volatileTime, XaTime &volatileDuration);

    XaErrorCode connectToNewElement(XaElement *newE, XaElement *&oldE,
				    XaTransferBuffer *&oldTB,
				    XaTime &deviceTime);

};

#endif // __port_h



