/* $XConsortium: intbuffer.h /main/10 1996/12/30 16:33:43 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __intbuffer_h
#define __intbuffer_h

#include <X11/Xmd.h>
#include <assert.h>
#include <collectable.h>
#include "xatime.h"
#include "buffer.h" // to get XaFormatCache

#ifndef NULL
#define NULL 0
#endif

class XaInternalBuffer
{
    void *buf;
    CARD32 bufSize;
    CARD32 refCount;
    BOOL freeOnDestroy;



public:
    XaInternalBuffer(CARD32 bufSize, void *buf = NULL);

    ~XaInternalBuffer(void);

    inline CARD32 GetSize() { return bufSize; }
    inline void *GetBuffer() { return buf; }
    inline CARD32 GetRefCount() { return refCount; }
    inline void Get(void) { assert(refCount > 0); refCount++; }
    inline void Release(void) { if (--refCount == 0) delete this; }

};

class XaAudioBuffer
{

    friend class XaAudioBufferCltn;
    friend class XaRingBuffer;
    friend class XaMixingBuffer;

private:
    XaInternalBuffer *buffer;
    XaTime _atTime;
    XaTime _duration;
    CARD32 _durationInBits;
    CARD32 _intBufferOffset; // where in the intbuffer's memory we begin
    CARD8 _leftPad;
    XaFormatCache *_formatCache;

    XaAudioBuffer *next, *prev;

public:
    XaAudioBuffer(XaInternalBuffer *ib,
		  XaTime atTime, XaTime length, CARD32 bitLength,
		  CARD8 leftPad, XaFormatCache *formatCache);
    XaAudioBuffer(XaInternalBuffer *ib,
		  XaTime atTime, XaTime duration,
		  CARD32 offset, CARD32 bitLength, CARD8 leftPad,
		  XaFormatCache *formatCache);
    
    ~XaAudioBuffer();

    // Access
    XaInternalBuffer *InternalBuffer() { return buffer; }
    CARD32 GetIntBufferOffset() { return _intBufferOffset; }
    void *GetBuffer() { return ((char *) buffer->GetBuffer())
			    + GetIntBufferOffset(); }

    inline CARD32 GetRefCount() { return buffer->GetRefCount(); }
    inline void Get(void) { buffer->Get(); }
    inline void Release(void) { buffer->Release(); }
    
    XaTime AtTime() { return _atTime;}
    XaTime Duration() { return _duration;}
    CARD32 DurationInBits() { return _durationInBits;}
    CARD8 LeftPad() { return _leftPad; }
    CARD32 GetSize() { return buffer->GetSize() - GetIntBufferOffset(); }
    XaAudioBuffer *Next() { return next; }
    XaAudioBuffer *Prev() { return prev; }

    // Data management
    XaAudioBuffer *Split(XaTime where, XaBoolean relative);
    
    // Computation
    inline XaBoolean BeforeTime(XaTime at) {return Before(at, _atTime); }
    inline XaBoolean AfterTime(XaTime at) {
	return !Before(at, (_atTime + _duration));
    }
    inline XaBoolean IncludesTime(XaTime at) {
	return ( !Before(at, _atTime) && Before(at, (_atTime + _duration)) );
    }
    
};

//
// XXXXXX
// This is implemented in classic linked list fashion.
// This "works" because we believe that for the most part
// we are inserting at the end, and taking from the head.
// But we need to maintain a sort order just in case.
//
// IF it turns out that our access is not queue style
// then we should consider a self-adjusting tree
// of some kind.
class XaAudioBufferCltn
{

private:
    XaAudioBuffer *first, *last;
    unsigned entries;
    
public:
    
    XaAudioBufferCltn();
    ~XaAudioBufferCltn();

    // Access
    XaAudioBuffer *First() { return first; }
    XaAudioBuffer *Last() { return last; }
    //
    // Manipulation
    //

    // Returns an XaValue error if you try and
    // insert into a time that is already there.
    XaErrorCode insert(XaAudioBuffer &ab);

    // Returns NULL, if you can't find the
    // an entry.
    XaAudioBuffer *remove(XaTime at);

    // Invariant checker
    void Invariant(void) const;

    XaTime LatestSample()
    {
	if (entries && last)
	    return (last->_atTime + last->_duration);
	else
	    return 0;
    }
    XaTime EarliestSample()
    {
	if (entries && first)
	    return (first->_atTime);
	else
	    return 0;
    }
};

#endif




