/* $XConsortium: element.cc /main/13 1996/12/30 16:33:29 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

/*
   An XaPort is a conduit of data between a client and a device, or between
   two devices.
*/

#include "element.h"
#include "connectors.h"
#include "device.h"
#include "port.h"

#ifdef DEBUG
#include "config.h"

static XaBoolean DoDebug ()
{
    static XaBoolean init = FALSE;
    static XaBoolean doit = FALSE;

    if (!init)
    {
	_XaConfigGetBool(".Element.debug", "", &doit);
	init = TRUE;
    }
    return doit;
}

#endif /* DEBUG */


XaErrorCode XaElement::Connect(XaPort *port, XaFormat *format,
			       XaTransferBuffer *&tb)
{

    XaErrorCode e;
    XaAttributeCBData cbdata;
    XaFormatCache oldFormat;

    
    // Delegate the connect ...
    if (!connectorDelegate)
	return XaEServerInternal;

    oldFormat = FormatCache();
    e = CacheFormat(format);
    if (e != XaESuccess)
    {
	// XXXXX send an error event!  Need to do this at every other
	// XXXXX possible failure point, also (pderr).
	return e;
    }
    cbdata.name = XaAformat;
    cbdata.value = format;
    cbdata.type = XaAformat;
    e = SetAttribute(Conn(), &cbdata);
    if (e != XaESuccess)
    {
	formatCache = oldFormat;
	return e;
    }

    if(e == XaESuccess)
	e = connectorDelegate->Connect(port, format, tb);

    // ... if it was sucessful, then we gotta hang onto the
    // returned transfer buffer for latter.
    if(e == XaESuccess)
    {
	// We believe (rely) that Success implies a tb.
	if( connections.insertKeyAndValue(*port, (void*)tb) == NULL)
	{
	    // We're already connected to this port.
	    // This should NOT happen.
	    e = XaEServerInternal;
	}
    }

    return e;
	
}

XaErrorCode XaElement::Disconnect(XaPort *port,  XaTransferBuffer &tb,
				  XaBoolean flush) {

    // Delegate the disconnect ....
    XaErrorCode e = (connectorDelegate)
				? connectorDelegate->Disconnect(port, tb, flush)
				: XaEServerInternal;

    // ... if it was succesul then we need to
    // remove the port from our connection list.
    // XXXXX  THIS SEEMS PROBLEMATIC. If the disconnect
    //        was not successful, are we still connected?
    //        I'm worried.
    if(e == XaESuccess) {
	if( connections.remove(*port) == NULL) {
	    e = XaEServerInternal;
	}
    }
    
    return e;
    
}


// For each port we've got call WriteTransfer with correct values.
XaErrorCode XaElement::GetData(XaTime minTime, XaTime maxTime,
			       XaTime &startTime, XaTime &endTime)
{
#ifdef DEBUG
    static lastMaxTime;
    static XaBoolean firstTime = XaTrue;

    if (DoDebug())
    {
	printf("XaElement::GetData: minTime: %d maxTime %d\n",
		minTime, maxTime);

	if (!firstTime)
	// This assertion is only valid while the Port is connected.
	// When a new port is connected, this is not valid.
	// assert(minTime == lastMaxTime + 1);
	firstTime = XaFalse;
	lastMaxTime = maxTime;
    }
#endif

    XaErrorCode e = XaESuccess;

    // Foreach port ....
    CARD32 bitsWritten;
    XaTime deviceTime;
    XaDictionaryIterator ports(connections);
    XaPort *thePort;

    endTime = minTime;

    while(thePort = (XaPort *)ports())
    {
	if (thePort->OutputRunning())
	{
	    CARD32 bitsToWrite =
		    formatCache.bitsPerFrame * Difference(1 + maxTime, minTime);

	    // XXXX Unclear on the reference clock here,
	    //      I think we want to specify this in term
	    //      of the localClock (but we don't currently
	    //      have that defined). 
	    e = thePort->WriteTransfer(minTime, XaAdeviceTime,
				       bitsToWrite, bitsWritten, deviceTime);

	    // XXXXX What if this fails?
	    //
	    
	    // XXXXX What should we do
	    // when bitsWritten doesn't correpsond to the duration
	    // implied by minTime - maxTime.

	    if (minTime + bitsWritten/formatCache.bitsPerFrame > endTime)
		endTime = minTime + bitsWritten/formatCache.bitsPerFrame;
	}
    }

    // XXXX Is this interface implementable?
    //      If we cache this.
    startTime = minTime;


    // XXX What do we do with the deviceTime that's
    // being returned. Should we cache it somewhere?
    

    // XXXX This can't be right?
    return XaESuccess;
    
}

XaErrorCode XaElement::PutData(XaTime minTime, XaTime maxTime,
			       XaTime &startTime, XaTime &endTime)
{
    return XaEUnimplemented;
}


void XaElement::SetConnectionDelegate(XaConnector &del) {
    connectorDelegate = &del;
    connectorDelegate->SetElement(this);
}

extern "C"
{
void XaSetDeviceConnector(void *device, void *connector)
{
    ((XaElement *)device)->SetConnectionDelegate(*(XaConnector *)connector);
}
}
