/* $XConsortium: config.h /main/2 1996/12/30 16:33:05 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#ifndef __config_h
#define __config_h

#include <Xa/Xalib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef enum {XaConfigUnknownQuiet, XaConfigUnknownWarn, XaConfigUnknownDie}
    XaConfigUnkown;
/*
** XaCreateConfig loads up the configuation database using the configuration
** file and command line options. This can be called multiple times (like
** every server reset).
** 	defaultFile - name of default configuaration file
**	appClass - class of application (free the string passed in);
**	warn - what to do if unused command line options.
*/

extern XaBoolean _XaCreateConfig(int argc, char *argv[], 
	char *defaultFile, char *appClass, XaConfigUnkown warn);

/*
** Once XaCreateConfig has been called, the default value you provide in
** the target can be overridden by the configuration by calling one of the
** following routines. The return value indicates whether or not the 
** configuration had a value for this particular resource.
** resName and resClass follow Xrm conventions.  Additionally, they
** may start with ".", in which case they are prepended with the application
** name or class.  resClass may be null.
** Do not free the string provided by _XaConfigGetString().
*/
extern XaBoolean 
	_XaConfigGetString(char *resName, char *resClass, char **target);
extern XaBoolean 
	_XaConfigGetInt32(char *resName, char *resClass, int *target);
extern XaBoolean 
	_XaConfigGetBool(char *resName, char *resClass, XaBoolean *target);

#ifdef __cplusplus
}
#endif

#endif
