/* $XConsortium: clientconn.h /main/5 1996/12/30 16:32:57 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// @DEC_COPYRIGHT@
//
// HISTORY
// $Log$
// Revision 1.1.1.5  1995/11/30  16:45:23  Peter_Derr
// 	add cleanup function to be called by signal handler
//
// Revision 1.1.1.4  1995/11/20  22:47:26  Peter_Derr
// 	basic protocol passing working
// 
// Revision 1.1.1.3  1995/11/07  19:36:22  Peter_Derr
// 	use ICE authorization
// 
// Revision 1.1.1.4  1995/10/19  19:57:13  Peter_Derr
// 	handle clients exiting
// 
// Revision 1.1.1.3  1995/10/19  17:38:41  Peter_Derr
// 	accepting ICE connections working
// 
// Revision 1.1.1.2  1995/10/17  17:47:53  Peter_Derr
// 	first pass at setting up ICE connection
// 
// $EndLog$
// 
// @(#)$RCSfile: clientconn.h $ $Revision: /main/5 $ (DEC) $Date: 1996/12/30 16:32:57 $
// 
#ifndef __Clientconn_h
#define __Clientconn_h 1
#include <X11/Xmd.h>
#include <X11/ICE/ICElib.h>
#include <X11/ICE/ICEproto.h>
#include <X11/ICE/ICEutil.h>
#include "scheduler.h"
#include <Xa/Xaprotocol.h>
#include "connection.h"
#include "tagrange.h"
#include "tagcounter.h"

/*

    Two types of Connection objects:

    ServerMaster

	This is the servers master connection object.  Contains all server's
	client connections.

	Subclass of ServerConnection

    ServerClient connection

	Server to client connections.

	Subclass of ServerConnection

	


 */


class XaClientConnection;
class XaTask;
class XaBag;

// Master Connection object contains all server's connections to clients

class XaMasterConnection : public XaConnection
{
 private:

    struct XaConnFd
    {
	XaConnection *conn;
	int fd;
    };

    int		    authCount;
    char	    *authNames[1];
    IcePaAuthProc   authProcs[1];
    IceAuthDataEntry *authDataEntries;

    int		versionCount;
    IcePaVersionRec versions;


    IceListenObj *listenObjs;
    int		listenObjCount;
    XaConnFd    *listenConnFds; /*file desc to listen on for new connections*/
    XaBag 	clients;

    static void runProc(XaTask *, void *);

    static Bool hostBasedAuthProc(char *);
    static Status protocolSetupProc(IceConn, int, int, char *, char *, 
				    IcePointer *, char **);
    static void protocolActivateProc(IceConn, IcePointer);

    // Object storage
    XaScalarBag classDB;
    XaScalarBag objectDB;
    
    // This is what manages the creation of tag ranges for
    // for the client side.
    XaTagRangeFactory tagRangeFactory;
    XaTagCounter parseConstantTags;
    XaTagCounter tagCounter;
    XaBag tagRanges;

    XaMasterConnection *masterConn;

    char *connIDs;

public:

    int setup(char *port, XaBoolean useAuth);
    void cleanup();
    // XaScheduler *scheduler;

    XaMasterConnection();
    ~XaMasterConnection();

    // things in XaConnection we need to implement
    virtual XaAtom	findAtom(char *name, XaBoolean create);

    virtual XaScalarBag &ObjectDB();
    virtual XaScalarBag &ClassDB();

    virtual XaConnection * Narrow(const char * className);

    virtual void        ReleaseTag(XaTag);

    XaTag       NewTag();

    XaTagRange *NewTagRange(XaConnection * connection, XaClass * theClass,
			    XaTag classID, XaTag name);

    int		acceptConnection(int);
    void        AddClient(XaClientConnection& newClient);
    void        RemoveClient(XaClientConnection *client);
    XaClientConnection *FindClient(IceConn connectionId);
    void        RemoveClient(IceConn connectionId);
    void        MarkForDelete(IceConn connectionId);
    static void processMsgProc(IceConn, IcePointer, int, unsigned long, Bool);
    static void errorHandler(IceConn);

    // For ease of use, for now.
    const char *connectionIds() { return connIDs; }
};

class XaFileTask;

// Server's connection to a client

class XaClientConnection : public XaProtocolConnection {

    friend class XaMasterConnection;

protected:

    IceConnectStatus connectStatus;
    Bool	markedForDelete;
    XaMasterConnection *masterConn;
    XaBag tagRanges;

public:


    XaFileTask	*task;

    XaClientConnection(XaMasterConnection*, IceConn);
    ~XaClientConnection();

    static void ProcessMessage(XaTask *,void *);

    static void errorHandler(IceConn);

    XaMasterConnection * MasterConnection() { return masterConn; }

    virtual XaAtom	findAtom(char *name, XaBoolean create);

    virtual XaScalarBag &ObjectDB();
    virtual XaScalarBag &ClassDB();

    virtual XaConnection * Narrow(const char * className);

    virtual void        ReleaseTag(XaTag);

    void FINDATOMprocessMsg(XaFindAtomRequest *req, unsigned long length, 
				Bool swap);
    void FINDOBJECTprocessMsg(XaFindObjectRequest *req, unsigned long length,
				Bool swap);
    void CREATEprocessMsg(XaCreateRequest *, unsigned long length, Bool swap);
    void DESTROYprocessMsg(XaDestroyRequest *, unsigned long length, Bool swap);
    void SETprocessMsg(XaSetRequest *, unsigned long length, Bool swap);
    void GETprocessMsg(XaGetRequest *, unsigned long length, Bool swap);
    void WRITEprocessMsg(XaWriteRequest *, unsigned long length, Bool swap);
    void READprocessMsg(XaReadRequest *, unsigned long length, Bool swap);
    void PINGprocessMsg(XaPingRequest *, unsigned long length, Bool swap);

    unsigned long sendMessage(XaProtoHeader *msgHeader, int dataLen, 
				char *data);
};
#endif




