/* $XConsortium: cdevice.h /main/5 1996/12/30 16:32:45 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __cdevice_h
#define __cdevice_h


#include "cobject.h"

_XAFUNCPROTOBEGIN

/*
 * C interface to dia.
 */


/*
 * Name of the function for device modules to
 * initialize the device
 */
#define DEVICE_INIT_FUNC "device_init"




/*
 * Local device Init func type.
 * This is the device init function.
 * It should return 0 for success, non-zero for failure.
 */
typedef int (*DeviceInitFunc)(void *, XaBoolean);
/* 
 * Not sure if this Open func is really needed...
 * Returns 0 for success, non-zero for failure. 
 */
typedef int (*DeviceOpenFunc)(void *, int mode);


/*
 * DeviceConnectFunc Connect callback.
 * Returns device-private connection identification data (void *)
 * which will be passed later on all Read and Write callbacks.
 * (called by XaDevice::connect)
 */
typedef void * (*DeviceConnectFunc)(void *port, void *format);

/*
 * DeviceDisconnectFunc Disconnect callback
 * Inform the device that no more data will be forthcoming.
 * If flush is set to True, stop immediately (if possible), else
 * continue playing remaining data in buffer.
 * (called by XaDevice::disconnect)
 */
typedef XaErrorCode (*DeviceDisconnectFunc)(void * port, void * connectId,
					XaBoolean flush);
/*
 * DeviceStartFunc
 * Optional device-specific Start callback.
 * Set for read or write update.
 */
typedef XaErrorCode (*DeviceStartFunc)(void);

/*
 * DeviceStopFunc Stop callback
 * Optional device-specific Stop callback.
 * Unset for read or write update.
 */
typedef XaErrorCode (*DeviceStopFunc)(void);


/*
 * DeviceUpdateFunc periodic update callback
 * Figure out the exact time interval of data we want.
 * 
 * Call C API of XaDevice::WriteTransfer:
 * DeviceWriteTransfer(device, atTime, refTime, &buf, bitsToWrite,
 * 		leftPad, &bitsWritten, &deviceTime);
 * 
 * If a transfer function was set up by the DeviceConnectFunc that will be
 * called, otherwise the WriteTransfer function will return a pointer to
 * requested data in the buf parameter.
 * 
 * If there is data returned in the buf parameter, get it to the hardware.
 * Update deviceTime, ring buffer parameters.
 * Figure out and return next update time.
 * 
 */
typedef struct timeval  (*DeviceUpdateFunc)();

/*
 * DeviceTimeUpdateFunc time update callback
 * return the current device time.
 */
typedef XaTime (*DeviceTimeUpdateFunc)();


/*
 * DeviceReadFunc Read callback
 * Returns number of bytes read in bitsRead param.
 */
typedef XaErrorCode (*DeviceReadFunc)(void *object, void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char **buf, CARD32 bitsToRead,
			    CARD8 *leftPad, CARD32 *bitsRead,
			    XaTime *deviceTime);

/*
 * DeviceWriteFunc Write callback
 * Returns number of bytes written in bitsWritten param.
 */
typedef XaErrorCode (*DeviceWriteFunc)(void *object, void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char *buf, CARD32 bitsToWrite, 
			    CARD8 leftPad, CARD32 *bitsWritten,
			    XaTime *deviceTime);

/*
 * DeviceShutdownFunc Shutdown callback
 * Close the device down.
 */
typedef void (*DeviceShutdownFunc)(void);

/*
Do we need this?
 */
/* Return 0 for success, non-zero for failure. */
typedef int (*DeviceResetFunc)(void *);

/*
Do we need this?
 */
/* Return 0 for success, non-zero for failure. */
typedef int (*DeviceDrainFunc)(void *);

/*
Do we need this?
 */
/* Return 0 for success, non-zero for failure. */
typedef int (*DeviceCloseFunc)(void *);


void SetDeviceOpenFunc(void *object, DeviceOpenFunc myFunc);
void SetDeviceReadFunc(void *object, DeviceReadFunc myFunc);
void SetDeviceUpdateTimeFunc(void *object, DeviceTimeUpdateFunc myFunc);
void SetDeviceWriteFunc(void *object, DeviceWriteFunc myFunc);
void SetDeviceResetFunc(void *object, DeviceResetFunc myFunc);
void SetDeviceDrainFunc(void *object, DeviceDrainFunc myFunc);
void SetDeviceCloseFunc(void *object, DeviceCloseFunc myFunc);

/*
 * provides data from device shared buffer for hardware to play.
 */
XaErrorCode DeviceWriteTransfer(void *object, void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char **buf, CARD32 samplesToRead,
			    CARD32 *samplesRead,
			    XaTime deviceTime);


/*
 * accepts data from hardware to write into device shared buffer 
 */
XaErrorCode DeviceReadTransfer(void *object, void *connectId,
			    XaTime atTime, XaAtom refTime, 
			    char *buf, CARD32 samplesToWrite, 
			    CARD8 leftPad, CARD32 *samplesWritten,
			    XaTime deviceTime);

/*
 * DeviceRingBufConfigure
 *
 * Configures parameters of the Device ring buffer.
 * Device object must already know the sample width in bits.
 * Units of size parameters are samples.
 * BUT, it is required that the specified size in samples fit into a whole
 * number of bytes.
 */
XaErrorCode DeviceRingBufConfigure(void *object, char **buf, XaTime size, 
				CARD32 nChannels, CARD32 sWidth,
				XaTime transferSize, XaTime sampleLimit, 
				XaTime hardwareTransferLimit,
				XaTime currentSample);

void *XaCreateMixingConnector(DeviceUpdateFunc, DeviceWriteFunc,
				DeviceConnectFunc, DeviceDisconnectFunc);
void *XaCreatePassThroughConnector(DeviceUpdateFunc, DeviceWriteFunc,
				DeviceConnectFunc, DeviceDisconnectFunc);
void XaSetDeviceConnector(void *device, void *connector);
_XAFUNCPROTOEND

#endif
