/* $XConsortium: buffer.h /main/5 1996/12/30 16:32:42 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef __buffer_h
#define __buffer_h

#include "object.h"

// XXXXX THIS SHOULD NOT BE HERE
//       We need to decided if there will be an actual XaFormat class
//       or if it's just a subclass of object.
typedef XaObject XaFormat;

struct XaFormatCache
{
    XaTime      sampleRate;
    XaAtom      encoding;
    CARD32      numChannels;
    CARD32      sampleWidth;    /* bits */
    CARD32      bitsPerFrame;    /* bits */
};


class XaPort;

class XaInternalBuffer;
class XaRingBuffer;
class XaTransferBuffer;

class XaBuffer : public XaObject
{
  public:

    XaBuffer(XaConnection *, XaClass *, XaTag objectTag, XaTag classID,
             XaTag name);

    ~XaBuffer();
    

    //
    // Data Movement in and out of these buffers.
    //

    virtual XaErrorCode Read(XaTime atTime, XaTag refTime, 
			     XaInternalBuffer *&buffer, CARD32 bitsToRead, 
			     CARD8 &leftPad, CARD32 &bitsRead, 
			     XaTime &deviceTime)
	    {return XaEUnimplemented;}
    
    virtual XaErrorCode Write(XaTime atTime, XaTag refClock, 
			      XaInternalBuffer &buffer,
			      CARD32 bitsToWrite, CARD8 leftPad,
			      CARD32 &bitsWritten, XaTime &deviceTime)
	    {return XaEUnimplemented;}


    //
    // The transfer functions instruct the Buffer
    // to perform the transfer to/from the transferBuffer.
    // No data actually transmits over this interface.
    // Data only transfers through the Read/Write interface.
    virtual XaErrorCode WriteTransfer(XaTime atTime, XaAtom refTime, 
				      CARD32 bitsToWrite, CARD32 &bitsWritten,
				      XaTime &deviceTime)
	    {return XaEUnimplemented;}

    virtual XaErrorCode ReadTransfer(XaTime atTime, XaAtom refTime,
				     CARD32 bitsToRead, CARD32 &bitsWritten,
				     XaTime &deviceTime)
            {return XaEUnimplemented; }

    XaErrorCode CacheFormat(XaObject *formatObject);

    XaFormatCache FormatCache() { return formatCache; }

protected:
    

    XaRingBuffer *ringBuffer;
    XaTransferBuffer *readDelegate;
    XaTransferBuffer *writeDelegate;
    XaFormatCache formatCache;

};


#endif
