//This line lets emacs recognize this as -*- C++ -*- Code
/* $XConsortium: xastring.h /main/3 1996/12/30 16:32:19 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//------------------------------------------------------------------------
//
//  File:	XaString.h
//  Project:	XA
//  Created:	@(#)
//  RespEngr:	Erling Wold
//  Revision:	1.29
//  Last Mod:	15 Jun 1994
//
//  Description: General string class. 
//	
//	
//	
//	
//------------------------------------------------------------------------
//
//


#ifndef XA_STRING_H
#define XA_STRING_H

#include "xadefines.h"
#include "collectable.h"

#define XA_DEFAULT_STRING_SIZE 80

class XaString : public XaCollectable {

public:

    // Constructors
    XaString();
    XaString(const char *cs);
    XaString(const XaString &);
    XaString(const char *cs, int N);

    ~XaString();

    // operator =
    XaString&	operator=(const char* cs);
    XaString&	operator=(const XaString& str);

    // Type casts.
    operator const char*() const;

    virtual XaCollectable* copy(void) const;
    virtual unsigned       hash(void) const;
    virtual XaBoolean	   equals(const XaCollectable& anObject) const;
    XaBoolean		   isNull() const;

    // Special methods for the string class
    long                length(void) const;
    XaErrorCode	append(const XaString&);
    XaErrorCode	append(const char *cs);

    // byte by byte equivalence.
    // You want all of these so the compiler doesn't get confused.
    friend XaBoolean operator==(const XaString& str1, const XaString& str2);
    friend XaBoolean operator==(const char *s1, const XaString& str2);
    friend XaBoolean operator==(const XaString& str1, const char *s2);
    friend XaBoolean operator!=(const XaString& str1, const XaString& str2);
    friend XaBoolean operator!=(const char *s1, const XaString& str2);
    friend XaBoolean operator!=(const XaString& str1, const char *s2);

    // NOTE: doesn't do bounds checking
    char& operator[](int i);

private:
    char* 		string;
    int  		allocSize;
};

#endif

