/* $XConsortium: tagset.h /main/4 1996/12/30 16:31:55 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#ifndef XA_TAGSET_H
#define XA_TAGSET_H

#include "xadefines.h"

#define XaNotFound -1

class XaTagSet {
public:
    XaTagSet(unsigned numBuckets = 16);
    XaTagSet(const XaTagSet & other);
    ~XaTagSet();

    friend class XaTagSetIterator;
    
    unsigned	entries(void) const { return nEntries; };

    XaTag       any() const;

    XaBoolean   contains(XaTag theTag) const;    

    XaBoolean	insert( XaTag theTag);

    XaBoolean	remove(XaTag theTag);

    void 	clear(void);
    
    XaTagSet&	operator=(const XaTagSet& other);
    
    XaBoolean   validate();

private:
    unsigned    hash(XaTag t) const;

    unsigned    find(XaTag theTag) const;

    XaTag    	at(unsigned index) const;

    XaTag       replaceAtIndex(unsigned index, XaTag theTag);

    void 	doubleSize(void);

    XaTag               *tagArray;
    unsigned 		allocSize;
    unsigned 		nBits;
    unsigned 		nEntries;
};

class XaTagSetIterator {
  public:
    XaTagSetIterator(const XaTagSet & set) : tagSet(set), index(0) {}

    XaTag operator () ()
    {
	XaTag tag;
	while ((tag = tagSet.at(index)) == NULL) {
	    index++;
	}
	index++;
	return tag;
    }
    void reset() { index = 0; }

private:
    const XaTagSet & tagSet;
    unsigned index;
};    

#endif /* XA_TAGSET_H */
