/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// Copyright (c) 1995 by Sun Microsystems, Inc.
//  -*-Mode: C++-*-

#ident	"@(#)tagcounter.cc	1.3 96/05/24 SMI"

#include "tagcounter.h"
#include "atom.h"
#include "atomdefs.h"

//////////////////////////////////////////////////////////////////////
//
// XaTagCounter
//
//////////////////////////////////////////////////////////////////////


XaTagCounter::XaTagCounter() :
    nextTag(0), lastTag(0), empty(XaTrue)
{
}


void
XaTagCounter::SetRangeWithLength(XaTag first, int length)
{
    nextTag = first;
    lastTag = first + length - 1;
    empty = !(nextTag <= lastTag);
}


XaTag
XaTagCounter::NewTag()
{
    if (empty)
	return XaTnone;

    XaTag tag = nextTag;

    // we need to be careful that we don't overflow before we figure
    // out if we've used the last tag;
    if (nextTag == lastTag)
	empty = XaTrue;
    else
	nextTag++;
    return tag;
}

int
XaTagCounter::TagsLeft()
{
    if (empty)
	return 0;
    return lastTag - nextTag + 1;
}
