/* $XConsortium: write.cc /main/4 1996/12/30 16:31:37 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#include <Xa/Xalib.h>
#include "buffer.h"
#include "intbuffer.h"
#include "serverconn.h"
#include <Xa/Xaprotocol.h>

void XaWrite(XaAudio connection, XaTag port,
             XaTime when, XaTag referenceTime,
             char *data, Card32 lengthInBits, Card8 pad,
             XaFinish *finish)
{
    XaServerConnection *conn = (XaServerConnection *)connection;

//
// Check if this object is in the client object database.
//
    XaObject *obj = (XaObject *)conn->ObjectDB().find(port);
//
// If it is, then set the attributes on the client side
//
    if (obj) {
      /* if read is supported
  	 Warning - not implemented yet 
      if (obj->IsWriteable()) { */
        XaBuffer    *buffer = (XaBuffer *)obj;
        CARD32       bitsWritten;
	XaTime       deviceTime;
 	XaErrorCode  err;

        XaInternalBuffer *ibuffer =
	    new XaInternalBuffer ((lengthInBits / 8), data);
        err = buffer->Write (when, referenceTime,
			     *ibuffer, lengthInBits, pad,
			     bitsWritten, deviceTime);
          
        ibuffer->Release();
	if (finish)
          finish->finishProc(finish->clientData);

      /*
      }
      */
    }
//
// otherwise, send the message to the server.
//
    else 
      ((XaServerConnection *)connection)->write(port,
				    when, referenceTime,
				    data, lengthInBits, pad, finish);

}

//
// Server write
//
void XaServerConnection::write(XaTag port, 
			 XaTime when, XaTag referenceTime,
			 char *data, Card32 lengthInBits, Card8 leftPad,
			 XaFinish *finish)

{
    XaWriteRequest req;
    XaTag	format;
    XaArgList	arg;
    CARD32	sampleWidth = 0;
    int		dataLength;
    XaProtoReply *reply;

    req.minorOpcode = WRITE;
    req.object = port;
    req.when = when;
    req.time_ref = referenceTime;


    req.bit_length = lengthInBits;
    req.leftPad[0] = leftPad;
    req.trigger = 666;

    dataLength = (lengthInBits + leftPad + 7)/8;

    sendMessage((XaProtoHeader *)&req, dataLength, data, finish, reply);
}
