/* $XConsortium: serverconn.cc /main/12 1996/12/30 16:31:22 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

//
// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// 
// @(#)$RCSfile: serverconn.cc $ $Revision: /main/12 $ (DEC) $Date: 1996/12/30 16:31:22 $
// 
/*

    Connection sequence:

	Server:

	    MasterConnection::setup()

		Calls IceRegisterForProtocolReply()

		Calls IceListenForConnections()

		Calls IceGetListenConnectionNumber() to get fd to listen on
		for new connections.

		Use select() or poll() to listen on the fd for new
		connections.

	Client:

	    Connection::setup()

		Calls IceRegisterForProtocolSetup()

	    Connection::open()

		Calls IceOpenConnection()

	Server:

	    Detect new connection on listen fd

	    MasterConnection::acceptConnection()

		Calls IceAcceptConnection()
		process setup and authentication messages

	Client:

		Send a Protocol Setup


 */
#include <stdio.h>
#include <stdlib.h>
#include <sys/param.h>
#ifdef  sun
#   define _POSIX_C_SOURCE	/* for utsname. Should be in config files ? */
#endif	/* sun */
#include <sys/utsname.h>

#ifdef hpux
#   include <time.h>
#else
#   include <sys/time.h>
#endif

#include "serverconn.h"
#include "class.h"
#include <Xa/Xaprotocol.h>
#include <Xa/Xafuncs.h>
#include <Xa/Xafuncproto.h>
#include "xastring.h"

extern "C" {
    extern IcePoAuthStatus _IcePoMagicCookie1Proc (IceConn, IcePointer *, 
		    Bool, Bool, int, IcePointer, int *, IcePointer *, char **);
	    }

// XaAtomStore XaConnection::atomDb;

//
// Client
//

XaServerConnection::XaServerConnection()
{
    vendorString = "X Audio SI";
    releaseString = "X0.0";
    versionCount = 1;
    versions.major_version = 1;
    versions.minor_version = 0;
    versions.process_msg_proc = processMsgProc;

    authCount = 1;
    authNames[0] = "MIT-MAGIC-COOKIE-1";
    authProcs[0] = _IcePoMagicCookie1Proc;

    iceOpCode = IceRegisterForProtocolSetup (XA_PROTOCOL_NAME, vendorString,
		    releaseString, versionCount, &versions, authCount,
		    authNames, authProcs, errorHandler);

    if (iceOpCode<0)
	{
	printf("Couldn't register XAUDIO protocol with ICE.\n");
	}

    // Get a per connection AtomCache
    if (atomCache.Init() != XaESuccess) {
	printf("Couldn't initialize the prdefined atoms\n");
    }

    clientSideTagCounter.SetRangeWithLength(XA_ATOM_CLIENT_BOTTOM,
					    XA_ATOM_CLIENT_TOP -
					    XA_ATOM_CLIENT_BOTTOM);
}

XaServerConnection::~XaServerConnection()
{
    
}


XaAtom
XaServerConnection::findAtom(char *name, XaBoolean create)
{
    return findAtom(name, create, NULL);
}

XaScalarBag &
XaServerConnection::ClassDB()
{
    return classDB;
}


XaScalarBag &
XaServerConnection::ObjectDB()
{
    return objectDB;
}



XaConnection *
XaServerConnection::Narrow(const char * className)
{
    if (strcmp(className, "XaServerConnection") == 0)
	return this;
    return NULL;
}

#if defined(USL) || defined(sco)
// XXX where is _SYS_NMLN supposed to come from?
#define _SYS_NMLN 128
#endif

#define _XA_MAX_NAME _SYS_NMLN

int
XaServerConnection::open(char *networkIds)
{

    // Deciding how to connect
    // 1. If we're told via the networkIDs
    //    use them.
    //
    // 2. Else check for the XAUDIO environment variable
    //
    // 3. Else check for the X11 DISPLAY environment
    //    variable, and hack that.
    //
    // 4. Else assume local machine.
    //
    if (!networkIds || !networkIds[0]) {
	
	// Look for the environtment variable
	if ((networkIds = (char *) getenv ("XAUDIO")) == NULL) {
	    // This string looks like:
	    //         tcp/HOSTNAME:DEFAULT_LISTEN_PORT;
	    // So the size is:
	    //        sizeof "tcp/:" + sizeof hostname _ size of port + NULL
	    int portSize = strlen(XA_DEFAULT_LISTEN_PORT);
	    char * newId = (char *) malloc(_XA_MAX_NAME + 5 + portSize + 1);
	    newId[0] = '\0';

	    // Add the header
	    strcat(newId, "tcp/");

	    // Find the host name
	    // XXXXX This would be a good place to look for
	    // the hostname via the DISPLAY environment variable.
	    struct utsname unameData;
	    if (uname(&unameData) >= 0)
		strncpy(newId + strlen(newId), unameData.nodename, 
			_XA_MAX_NAME);

	    // Finish up with the colon and well known port number
	    strcat(newId, ":");
	    strcat(newId, XA_DEFAULT_LISTEN_PORT);

	    // And there we are.
	    networkIds = newId;
	}
    }
    
#ifdef DEBUG
    fprintf(stderr, "Connecting with %s\n", networkIds);
#endif
    connectionId = IceOpenConnection (networkIds, NULL, False, iceOpCode,
	sizeof(errorBuf), errorBuf);


    if (!connectionId)
	{
	printf("XaServerConnection::open: IceOpenConnection failed.\n");
	printf("Error mesage: %s\n", errorBuf);
	return 0;
	}
	
    char *connectStr;
    connectStr = IceConnectionString(connectionId);
#ifdef DEBUG
    printf("Connection Opened: ");
    printf("IceConnectionNumber = %1d",IceConnectionNumber(connectionId));
    printf(", IceConnectionString = %s\n",connectStr);
#endif
    free(connectStr);

    FD_SET(IceConnectionNumber(connectionId), &readMask);

    int majorVersion, minorVersion;
    char *vendorStr,*releaseStr;
    char errorStr[256];
    IceProtocolSetupStatus      protoSetupStatus;


    protoSetupStatus = IceProtocolSetup(connectionId, iceOpCode,
					(IcePointer)this, False,
					&majorVersion, &minorVersion,
					&vendorStr, &releaseStr,
					255, errorStr);

    
    if (protoSetupStatus != IceProtocolSetupSuccess)
    {
        fprintf(stderr,"IceProtocolSetup failed due to ");
        switch(protoSetupStatus)
        {
            case IceProtocolSetupFailure:
            {
                fprintf(stderr,"IceProtocolSetupFailure\n");
                break;
            }
            case IceProtocolSetupIOError:
            {
                fprintf(stderr,"IceProtocolSetupIOError\n");
                break;
            }
            case IceProtocolAlreadyActive:
            {
                fprintf(stderr,"IceProtocolAlreadyActive\n");
                break;
            }
            fprintf(stderr,":  %s",errorStr);
        }
    }
    switch (IceConnectionStatus(connectionId))
	{
	case IceConnectAccepted:
	    printf ("Connection accepted\n");
	    break;

	case IceConnectPending:
	    printf ("Connection pending\n");
	    break;

	case IceConnectRejected:
	    printf ("Connection Rejected\n");
	    break;

	case IceConnectIOError:
	    printf ("Connection IOError\n");
	    break;
	}

    // Read the startup message
    IceProcessMessages(connectionId, NULL, NULL);

    return 1;
}

void XaServerConnection::errorHandler(IceConn conn)
{
    printf("XaServerConnection::errorHandler: Error on %d\n", conn);
}

Status XaServerConnection::pingServer(void)
{
    Status status;

    status = IcePing(connectionId, pingReplyProc, NULL);
    if (status < 0)
	fprintf(stderr, "Ping Failed\n");
    return(status);
}

void XaServerConnection::pingReplyProc(IceConn iceConn, IcePointer clientData)
{
#ifdef DEBUG
    printf("Ping Reply received.\n");
#endif
}

//
// XaServerConnection::sendMessage
//
//	msgHeader	message header with minor opcode filled in
//	dataLen		length of extra data in bytes
//	data		extra data
//	finish		XaFinish callback struct pointer

XaArgVal XaServerConnection::sendMessage(XaProtoHeader *msgHeader,
					int	dataLen, 
					char	*data, 
					XaFinish *finish,
					XaProtoReply *& reply)
{
    unsigned long	sequenceNumber;
    int			msgLen;
    CARD32		reply_id;
    XaArgVal		returnValue = NULL;

    reply_id = IceLastSentSequenceNumber(connectionId) + 1;

// This macro sets up the ICE message header with the IceGetHeader macro,
// copies the rest of the Xa*Header fields into the ICE buffer, and
// sets the message ICE message length field.

#define _XaServerConnection_GetHeader(_opcode, _reqType) \
    _reqType *ptr##_opcode; \
    IceGetHeader(connectionId, iceOpCode, _opcode, \
		sizeof(_reqType), _reqType, ptr##_opcode); \
    memcpy((char *)ptr##_opcode + sizeof(XaProtoHeader),  \
	(char *)msgHeader + sizeof(XaProtoHeader), \
	sizeof(_reqType) - sizeof(XaProtoHeader)); \
    msgLen = sizeof(_reqType) - sizeof(iceMsg) + dataLen; \
    ptr##_opcode->length = (msgLen + 7) >> 3;


    switch (msgHeader->minorOpcode)
	{
	case FINDATOM:
	    _XaServerConnection_GetHeader(FINDATOM, XaFindAtomRequest);
	    ptrFINDATOM->reply_id =  reply_id;
	    break;
	    
	case FINDOBJECT:
	    _XaServerConnection_GetHeader(FINDOBJECT, XaFindObjectRequest);
	    ptrFINDOBJECT->reply_id = reply_id;
	    break;
	    
	case CREATE:
	    _XaServerConnection_GetHeader(CREATE, XaCreateRequest);
	    break;
	    
	case DESTROY:
	    _XaServerConnection_GetHeader(DESTROY, XaDestroyRequest);
	    break;
	    
	case SET:
	    _XaServerConnection_GetHeader(SET, XaSetRequest);
	    break;
	    
	case GET:
	    _XaServerConnection_GetHeader(GET, XaGetRequest);
	    ptrGET->reply_id = reply_id;
	    break;
	    
	case WRITE:
	    _XaServerConnection_GetHeader(WRITE, XaWriteRequest);
	    break;
	    
	case READ:
	    _XaServerConnection_GetHeader(READ, XaReadRequest);
	    ptrREAD->reply_id = reply_id;
	    break;

	case PING:
	    _XaServerConnection_GetHeader(PING, XaPingRequest);
	    ptrPING->reply_id = reply_id;
	    break;

	default:
	    fprintf(stderr, "XaServerConnection::sendMessage: Unknown opcode %d\n",
		    msgHeader->minorOpcode);
	    return 0;
	}


    if (dataLen > 0)
	{
	// this is a macro
	IceWriteData(connectionId, dataLen, data);
	}

    if (msgLen % 8 > 0)
	{
	// need to pad to 8-byte boundary
	// this is a macro
	_XaWritePad(connectionId, 8 - (msgLen % 8));
	}

    sequenceNumber = IceLastSentSequenceNumber(connectionId);
    IceFlush(connectionId);

    //  Replies are only expected for GET, FINDOBJECT, FINDATOM, READ or PING

    if (msgHeader->minorOpcode == GET 
	    || msgHeader->minorOpcode == FINDATOM
	    || msgHeader->minorOpcode == FINDOBJECT 
	    || msgHeader->minorOpcode == READ
	    || msgHeader->minorOpcode == PING)
	{
	if (!finish)
	    {
	    // Synchronous mode, wait for reply.
	    // This all gets revised when we add an event queue

	    IceReplyWaitInfo replyWaitInfo;
	    XaReplyWaitInfo replyInfo;
	    Bool replyReady;

	    replyInfo.replyID = reply_id;
	    replyInfo.returnData = &returnValue;


	    replyWaitInfo.sequence_of_request = sequenceNumber;
	    replyWaitInfo.major_opcode_of_request = iceOpCode;
	    replyWaitInfo.minor_opcode_of_request = msgHeader->minorOpcode;
	    replyWaitInfo.reply = &replyInfo; 

	    replyReady = False;
	    while (!replyReady)
		{
		if (IceProcessMessages(connectionId, &replyWaitInfo,
				    &replyReady) != IceProcessMessagesSuccess)
		    {
		    printf("Error while waiting for reply.\n");
		    return NULL;
		    }
		//
		// Check the event queue to see if the message we're waiting
		// for is there.  CAN happen...
		//
		}
#ifdef DEBUG
	    printf("Reply received to message %ld\n", sequenceNumber);
#endif

	    reply = (XaProtoReply *)replyWaitInfo.reply;

	    // Whatever data we're expecting to be supplied by this reply
	    // should be in the returnValue.

	    }
	else
	    {
	    // Big Hole!!!!
	    // Asynchronous mode
	    // Add replyID to list of requests for which a reply is waiting
	    // Event handler will call the finish proc.
	    }
	}
    else if (finish)
	{
	// no reply is expected, call the finish proc now.
	(*finish->finishProc)(finish->clientData);
	}

    return returnValue;
}

XaTag XaServerConnection::NewTag()
{
    XaTag result = tagCounter.NewTag();

#ifdef notdef
    // if it returns none then we need to wait until more tags arrive
    if (result == XaTnone)
	result = waitForMoreTags();

    // if we are getting low on tags then we ask for more
    // for now we request them only once we've run out
    if (tagCounter.tagsLeft() == 0)
	requestMoreTags();
#endif

    return result;

}


XaTag
XaServerConnection::NewClientSideTag()
{
    return clientSideTagCounter.NewTag();
}

void
XaServerConnection::ReleaseTag(XaTag tag)
{
    // XXX tkr
#ifdef DEBUG
    fprintf(stderr, "Released tag %u\n", tag);
#endif
}


void XaServerConnection::mainLoop()
{
    while (1)
	{
	fd_set	newReadMask;
	int	status;

	newReadMask = readMask;

	// when timeouts are added will need to specify a timeout

	status = select(FD_SETSIZE,
#ifdef hpux
			(int *)
#endif
			&newReadMask, NULL, NULL, NULL);

	if (status < 1)
	    {
	    fprintf(stderr, "XaServerConnection::mainLoop: select failed, returned %d\n", status);
	    exit(1);
	    }
	if (!FD_ISSET(IceConnectionNumber(connectionId), &newReadMask))
	    {
	    fprintf(stderr, "Hunh!?!? Who's talking to me?\n");
	    }
	else
	    {
	    IceProcessMessagesStatus    processStatus;
	    Bool                        replyReady;

	    processStatus = IceProcessMessages(connectionId, NULL,
				    &replyReady);
	    if (processStatus != IceProcessMessagesSuccess)
		{
		switch(processStatus)
		    {
		    case IceProcessMessagesIOError:
			{
			fprintf(stderr, "IceProcessMessagesIOError\n");
			IceCloseConnection(connectionId);
			break;
			}
		    case IceProcessMessagesConnectionClosed:
			{
			fprintf(stderr, "IceProcessMessagesConnectionClosed\n");
			break;
			}
		    default:
			{
			fprintf(stderr, "Unknown status %1d\n",processStatus);
			IceCloseConnection(connectionId);
			break;
			}
		    }
		break; // out of while
		}
	    }
	}
}

extern XaCreateClassFunc XaCreateClassCore;
extern XaCreateClassFunc XaCreateClassFile;

static XaCreateClassFunc *WellKnownClientClasses[] =
{
    &XaCreateClassCore,
    &XaCreateClassFile,
};

XaErrorCode XaCreateWellKnownClientClasses(XaConnection *conn)
{
    XaErrorCode ret = XaESuccess;
    int n, nclasses = XaNumber(WellKnownClientClasses);

    for (n = 0; n < nclasses; n++)
        if ((ret = (*WellKnownClientClasses[n])(conn)) != XaESuccess)
            return ret;
    //The following macro gives a way to add tests
#ifdef TEST_POINT
    TEST_POINT;
#endif

    return ret;
}

XaAudio XaOpenAudio(char *networkID, char *errString, int *argc, char *argv[])
{
    XaServerConnection *conn;

    // QUESTION:: How big is the errString buffer???

    int i, j;

    if ((!networkID) || (!networkID[0]))
    for (i=0; i<*argc; i++)
	{
	if (0==strncmp("-conn", argv[i], 5))
	    {
	    networkID = argv[i+1];
	    *argc -= 2;
	    for (j=i; j<*argc; j++)
		{
		argv[j] = argv[j+2];
		}
	    }
	}

    conn = new XaServerConnection;

    if (!conn->open(networkID))
	{
	if (networkID && networkID[0])
	    sprintf(errString,"Couldn't open connection %s.\n", networkID);
	else
	    sprintf(errString,"Couldn't open connection.\n");
	return NULL;
	}

// Create Well Known Classess on the client side

    XaCreateWellKnownClientClasses(conn);
    
    return (XaAudio)conn;
}


void XaCloseAudio(XaAudio connection)
{
    XaServerConnection *conn;

    conn = (XaServerConnection *)connection;

    //  need to free a bunch of stuff, call the right Ice functions 
    //  and be a little less brutal...

    IceCloseConnection(conn->connectionId);

    delete conn;
}

void XaFlush(XaAudio connection)
{
    XaServerConnection *conn;

    conn = (XaServerConnection *)connection;

    IceFlush(conn->connectionId);
}

void XaMainLoop(XaAudio connection)
{

    XaServerConnection *conn;

    conn = (XaServerConnection *)connection;
    conn->mainLoop();
}

int XaServerConnectionNumber(XaAudio connection)
{
    return IceConnectionNumber(((XaServerConnection *)connection)->connectionId);
}

//
// This will be completely revised when we add an event queue.
//
void XaXtProcessEvents(XtPointer connection, int *fd, XtInputId *id)
{
    XaServerConnection *conn;
    IceProcessMessagesStatus    processStatus;
    Bool                        replyReady;
    
    conn= (XaServerConnection *)connection;

    if (IceConnectionNumber(conn->connectionId) != *fd)
	{
	fprintf(stderr, "XaXtProcessEvents: Fatal error: wrong fd %d\n", *fd);
	}

    processStatus = IceProcessMessages(conn->connectionId, NULL,
			    &replyReady);
    if (processStatus != IceProcessMessagesSuccess)
	{
	switch(processStatus)
	    {
	    case IceProcessMessagesIOError:
		{
		fprintf(stderr, "IceProcessMessagesIOError\n");
		IceCloseConnection(conn->connectionId);
		break;
		}
	    case IceProcessMessagesConnectionClosed:
		{
		fprintf(stderr, "IceProcessMessagesConnectionClosed\n");
		break;
		}
	    default:
		{
		fprintf(stderr, "Unknown status %1d\n",processStatus);
		IceCloseConnection(conn->connectionId);
		break;
		}
	    }
	}
}
