/* $XConsortium: paramlist.cc /main/3 1996/12/30 16:31:13 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: paramlist.cc $ $Revision: /main/3 $ (DEC) $Date: 1996/12/30 16:31:13 $
// 
#include <Xa/atomstrings.h>
#include <string.h>
#include <assert.h>
#include "connection.h"
#include "cobject.h"

//
// Is the itemList null terminated?  If not, we need a size.
//
//	itemList	pointer to raw protocol data
//	length		lenght in bytes of raw protocol data
//	attrCount	returned cound of parsed attributes
//
XaArgVal XaProtocolConnection::parseParamList(XaProtoItem *itemList, 
					    int length, int& attrCount,
					    XaBoolean makeArgList)
{

    XaArgVal	retList;
    XaProtoItem *itemPtr = itemList;
    int		bytesRead = 0;
    XaAttributeCBData *newAttr;
    XaArgs		*newArg;

    attrCount = 0;

    // Input buffer must be at least large enough for one item.

    if (length < sizeof(XaProtoItem))
	return NULL;


    parseBuffer.Lock();

    while ((bytesRead < length) && itemPtr->name)
	{

	if (makeArgList)
	    {
	    newArg = (XaArgs *)parseBuffer.Reserve(sizeof(XaArgs));
	    newArg->name = (char *)AtomCache().StringByAtom(itemPtr->name);
	    // If we don't have a string for this atom we must not have
	    // asked for it so we don't care.
	    if (!newArg->name)
		newArg->name = XaNnone;
	    }
	else
	    {
	    newAttr =
	    (XaAttributeCBData *)parseBuffer.Reserve(sizeof(XaAttributeCBData));
	    newAttr->name = itemPtr->name;
	    }

	if (itemPtr->name == XaAarray
		|| itemPtr->name == XaAcollectionReplace
		|| itemPtr->name == XaAcollectionAdd
		|| itemPtr->name == XaAcollectionSubtract )
	    {
	    XaProtoArray *arrayPtr = (XaProtoArray *)itemPtr;
	    XaArray *arrayItem;
	    CARD32 *array = new CARD32[arrayPtr->length];

	    if (makeArgList)
		{
		// Arg has array atom, array length
		newArg->value = (XaArgVal)arrayPtr->length;

		// next arg contains attrbute name, array pointer
		newArg = (XaArgs *)parseBuffer.Reserve(sizeof(XaArgs));
		newArg->name = (char *)AtomCache().StringByAtom(arrayPtr->name);
		if (!newArg->name)
		    newArg->name = XaNnone;
		newArg->value = (XaArgVal)array;
		}
	    else
		{
		arrayItem = new XaArray;
		newAttr->value = arrayItem;
		arrayItem->arrayAtom = itemPtr->name;
		arrayItem->length = arrayPtr->length;
		arrayItem->name = arrayPtr->name;
		arrayItem->elements = array;
		}

	    // elements are immediately after the XaProtoArray struct 
	    // in the protocol buffer.
	    memcpy(array, (void *)(arrayPtr + 1), 
			    arrayItem->length * sizeof(CARD32)); 

	    // Advance itemPtr past the end of the array
	    arrayPtr++;
	    itemPtr = (XaProtoItem *)((char *)arrayPtr 
				+ (arrayItem->length * sizeof(CARD32)));
	    }

	else // not an array
	    {
	    if (makeArgList)
		newArg->value = (XaArgVal)itemPtr->value;
	    else
		newAttr->value = (void *)itemPtr->value;
	    itemPtr++;
	    }

	bytesRead = (int)((char *)itemPtr - (char *)itemList);
	attrCount++;
	}

    assert(bytesRead <= length);


    if (makeArgList)
	{
	// ArgList needs to be NULL-terminated.

	newArg = (XaArgs *)parseBuffer.Reserve(sizeof(XaArgs));
	newArg->name = NULL;
	newArg->value = NULL;
	}

    retList = (XaArgVal)parseBuffer.Buffer();
    parseBuffer.Unlock();
    return retList;
}
