/* $XConsortium: find.cc /main/2 1996/12/30 16:31:07 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// 
// @(#)$RCSfile: find.cc $ $Revision: /main/2 $ (DEC) $Date: 1996/12/30 16:31:07 $
// 
#include <Xa/Xaprotocol.h>
#include "xastring.h"
#include "serverconn.h"
#include <Xa/atomstrings.h>

XaAtom XaServerConnection::findAtom(char *name, XaBoolean create, 
				    XaFinish *finish)
{
    XaArgList	arglist;
    XaAtom	retAtom;
    XaAtom	*retAtoms;
    XaFindReply	*reply;
    XaProtoReply *protoReply;

    if (!(retAtom = AtomCache().AtomByString(name)))
	{
	XaFindAtomRequest req;
	unsigned long sequenceNumber;

	req.minorOpcode = FINDATOM;
	req.create = create;
	// req.reply_id = ??????

	retAtoms = (XaAtom *)sendMessage((XaProtoHeader *)&req,
					strlen(name) + 1, 
					name, finish,
					protoReply);
	reply = (XaFindReply *)protoReply;
	if (retAtoms)
	    {
	    retAtom = *retAtoms;
	    AtomCache().AddAtom(retAtom, name);
	    }
	else
	    {
	    retAtom = 0;
	    }

	}
    return retAtom;
}

XaArgList XaServerConnection::findObject(XaTag classId, XaFinish *finish,
					va_list argp)
{
    XaFindObjectRequest req;
    unsigned long sequenceNumber;
    XaFindReply	*reply;
    XaProtoReply *protoReply;
    XaArgList retArgList;

    req.minorOpcode = FINDOBJECT;
    // req.reply_id = ??????
    req.classId = classId;

    protocolBuffer.Lock();
    processVarargs(argp, finish);

    retArgList = (XaArgList)sendMessage((XaProtoHeader *)&req,
					protocolBuffer.ProtoLength(),
					protocolBuffer.Buffer(), finish,
					protoReply);
    reply = (XaFindReply *)protoReply;

    protocolBuffer.Unlock();

    // NOTE:  Gap here!!!
    // sendMessage really returned a list of Tags.
    // Need to convert it to ArgList

    return retArgList; // for now...

}

XaArgList XaServerConnection::findObject(XaTag classId, XaFinish *finish, ...)
{
    va_list     argp;
    XaArgList	retArglist;

    va_start(argp, finish);
    retArglist = findObject(classId, finish, argp);
    va_end(argp);

    return retArglist;
}

//
// 
//
XaArgList XaFindObject(XaAudio connection, XaTag classId, XaFinish *finish, ...)
{
    va_list     argp;
    XaArgList	retArglist;


    va_start(argp, finish);
    retArglist = ((XaServerConnection *)connection)->findObject(classId,
		    finish, argp);
    va_end(argp);

    return retArglist;
}


XaAtom XaFindAtom(XaAudio connection, char *searchString, XaBoolean create,
			XaFinish *finish)
{

    return ((XaServerConnection *)connection)->findAtom(searchString, create,
							finish);

}
