/* $XConsortium: create.cc /main/4 1996/12/30 16:30:57 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: create.cc $ $Revision: /main/4 $ (DEC) $Date: 1996/12/30 16:30:57 $
// 
#include <stdarg.h>
#include <Xa/Xalib.h>
#include "serverconn.h"
#include "class.h"
#include <Xa/Xaprotocol.h>

XaTag XaCreate(XaAudio connection, char *objectClassName, ...)
{
    va_list	argp;
    XaTag	tagRet;
    XaClass    *c;
    ATOM	classAtom;

    XaServerConnection *conn = (XaServerConnection *)connection;

    classAtom = conn->findAtom(objectClassName, TRUE, NULL);

    // Look for this class in the client side classDB.
    c = (XaClass *)conn->ClassDB().find(classAtom);

    // If this class exists in client classDB, create
    // this object on the client side.
    // Note: Fix this to handle array type atoms
    if (c) {  	
      CARD32 noOfAttrs = 0;

      // count the number of attrs.
      va_start(argp, objectClassName);
      noOfAttrs = conn->noOfAttrs(argp);
      va_end(argp);

      // Create the client side object. 
      va_start(argp, objectClassName);
      tagRet = conn->create(classAtom, noOfAttrs, argp);
      va_end(argp);

    }

    // else create this object
    // in the server.
    else {
      va_start(argp, objectClassName);
      tagRet = conn->create(classAtom, argp);
      va_end(argp);
    }

    return tagRet;
}

TAG XaServerConnection::create(ATOM classAtom, va_list argp)
{
    XaCreateRequest req;
    XaFinish *finish = NULL;
    XaProtoReply *reply;

    req.minorOpcode = CREATE;
    req.classId = classAtom;
    req.id = NewTag();

    protocolBuffer.Lock();
    processVarargs(argp, finish);

    // If the attribute list needs to be null-terminated --
    // addProtoItem(NULL, 0);

    sendMessage((XaProtoHeader *)&req, protocolBuffer.ProtoLength(), 
		protocolBuffer.Buffer(), finish, reply);

    protocolBuffer.Unlock();
    return req.id;
}

CARD32 XaServerConnection::noOfAttrs(va_list argp)
{
    CARD32  count = 0;

    while (va_arg(argp, char *)) {
      va_arg(argp, void *);
      count++;
    }
    return count;
}

TAG
XaServerConnection::create(ATOM classAtom, CARD32 noOfAttrs, va_list argp)
{
      XaAttributeCBData *attrs = XA_NULL;
      XaObject *clientObject = XA_NULL;
      char *itemName;
      void *value;

      if (noOfAttrs) {
	attrs = new XaAttributeCBData[noOfAttrs];
  	int i = 0;	
        while (itemName = va_arg(argp, char *)) {
          XaAtom nameAtom = findAtom(itemName, TRUE, NULL);
  	  value = va_arg(argp, void *);
	  attrs[i].name = nameAtom;
	  attrs[i].value = value;
	  i++;
        }
      }

      XaTag tag = NewClientSideTag();
      clientObject = XaCreateObject (this, classAtom, tag,
				     XaTnone, attrs, noOfAttrs);
      if (attrs)
	delete attrs;

      if (!clientObject)
        return XaTnone;
      else
        return tag;

      return tag;
 
}
