/* $XConsortium: object.h /main/7 1996/12/30 16:30:44 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

/*
 * Server objects are fundamentally just a collection of
 * attributes. Specialized objects may have some
 * specialization of behaviour, but all objects
 * will have the attribute interface.
 *
 * The Attribute Set/Get Interface
 * There are two goals to strive for in this interface.
 * 1. Atomicity of multiple value set/gets
 * 2. Ease of specialization for object subclasses.
 *
 * The first goal states that more than one attribute can
 * be set in a single set call, and if, for any reason, one
 * of the attributes is invalid or a value for an attribute
 * is invalid, then none of the attribute changes in the set
 * will take affect. 
 * 
 * The second goal is intended to ensure that predefined default actions
 * will occur in a simple object, and can be overridden in the case
 * of more complicated objects and subclasses.
 * 
 * With these points in mind the set interface has been
 * broken down into the following sub functions; defaults
 * are provided for all of these subfunctions.
 *
 * 1. TypeCheck
 * Simple type checking occurs for each value in a set,
 * if any value is not of the correct type, then the set fails
 * and therefore the entire set fails (ie. no values are set.)
 * This occurs for each attribute one attribute at a time. If
 * any TypeCheck call fails, the Set immediately returns as a
 * failure.
 *
 * 2. Validation
 * The entire set of attributes is passed to a single validation
 * function. The intent is that the validation function will
 * ensure that invalid relationships among attributes are not
 * specified (eg. It is illegal to use mu-law encoding on 16 bit data.)
 * If validation succeedes then Set is guaranteed to succeed.
 * 
 * Since this is the last place to fail we need to think
 * about memory allocations, and whether or not we
 * need to provide backing out of Validation (set)? What
 * about subclasses can they each have a validate method?
 * 
 * 3. Set
 * This operation actually effects the attribute change, including
 * updating a local, per instance, cache. Set is not allowed to
 * fail.
 *
 * In addition for TypeCheck and Set, each attribute has it's
 * own method.
 
 * Thus, for clarity, the algorithm looks like:
 *
 *     foreach attribute in attributeSet
 *         if TypeCheck[attribute](value) fails
 *            return FAIL
 *     if Validate(attributeSet) fails
 *            return FAIL
 *     foreach attribute in attributeSet
 *            Set[attribute](value)
 *     return Success
 *
 * Where TypeCheck[attribute](value) mean: Apply the TypeCheck function
 * associated with attribute to value, where value is the desired
 * new value for attribute.
 *
 
 * Concerns over breaking up the SetAttribute call into separate
 * TypeCheck, Validation, Set functions:
 * Will it ever be the case that between a call to validate
 * and set that validate would fail? If so then, persumeably
 * the set would fail which currently is not allowed.
 *
 * What about get? Is there atomicity requirements here?
 * In which case a callback entry for getting a large bunch of values
 * at once should also be provided.
 *
 *
 *
 * HOW ABOUT ONE GET CALL as opposed to a bunch.
 *
 * What about SUBCLASSING of this interface.
 *
 * SET's from BELOW (dda)
 * GET's from BELOW (dda)
 *
*/

#ifndef __object_h
#define __object_h
#include "bag.h"
#include "xastring.h"
#include <Xa/atomdefs.h>
#include "ctag.h"
#include "cobject.h"

#ifdef NEVER
/*
 * What an attribute looks like to a callback.
 *
 * Names need to be changed to Tags when we have the
 * Tag code.
 *
 * TODO: jdr 11/26/95
 * MEMORY LEAK: Until there is a mechanism for
 * deleting objects based on the type, then
 * the "values" in a CBData object will leak.
*/
extern "C" {
struct XaAttributeCBData {
    char *name;          // Attribute Name Tag 
    XaTag type;          // Attribute Type Tag 
    void *value;         // The current value of attribute 
    void *newValue;      // The "new" value in a Set/Validate/Check call.
};
};


/*
 * TypeCheck callback
 *
 * XaBoolean XaAttributeCheckCB(void *object,  XaAttirbuteCB *attribute);
 * 
 * Often the defaults are all that will be required, but
 * in the special cases where explicit range checking 
 * can occur before a validation this can be overloaded
 * to provide that range checking.
 * 
*/
extern "C" {
typedef XaBoolean (*XaAttributeCheckCB)(void *, XaAttributeCBData *);
}
/* Validate callback
 *
 * XaBoolean XattributeValidateCB(void *object,
 *                               int count, XaAttributeCDData **attributes);
 * 
 * User supplied validate callback, failure (non-zero return)
 * stops set operation.
 *
 * In particular this should check for interdependancies
 * of attributes and not allow invalid combinations.
 *
 * returns 0 on success, non-zero on failure.
*/
extern "C" {
typedef XaBoolean (*XaAttributeValidateCB)(void *, int, XaAttributeCBData **); 
};
/* Set/Get callback
 * 
 * User supplied set and get callbacks - these should
 * never fail.

 * void attributeSetCB(void *object, XaAttributeCBData *attribute);
 * void attributeGetCB(void *object, XaAttributeCBData *attribute);
 *
 * The requirements on the functions are:
 * 
 * SET
 *     do whatever is necessary to affect the state
 *     change represented by setting the attribute
 *     to the new value, found in newValuein the CBData struct.
 *     XaObject will be responsible for maintaining the local cache
 *     by setting value to newValue when the CB had returned.
 *
 * GET
 *     Do whatever is required to get the value
 *     and return the new value in the newValue
 *     part of the CBdata.
*/
extern "C" {
typedef void (*XaAttributeSetCB)(void *, XaAttributeCBData *);
typedef void (*XaAttributeGetCB)(void *, XaAttributeCBData *);
};
#endif

class XaConnection;
class XaClass;
class XaClassAttribute;
class XaObject;

/* This is what gets stored in the attribute bag in XaObject */
class XaAttribute : public XaCollectable
{
public:
    
    /* Null means the functions don't get called
    * TODO: jdr 11/26/95 Default functions need
    * to be put into place based on type.
    */
    XaAttribute(XaTag n, XaClassAttribute *ca, void *v,
		XaTag t = XaTnone,
		XaAttributeSetCB sCB = NULL,
		XaAttributeGetCB gCB = NULL,
		XaAttributeCheckCB cCB = NULL);
    virtual ~XaAttribute();

    /* Access functions */
    inline void *Value() {return attribute.value;}
    inline void *Value(void *v) {
	void *ov = attribute.value; attribute.value = v; return ov; }

    inline XaAttributeSetCB Set() { return setCB;}
    inline XaAttributeSetCB Set(XaAttributeSetCB cb) {
	XaAttributeSetCB ov = setCB; setCB = cb; return ov; }

    inline XaAttributeGetCB Get() { return getCB;}
    inline XaAttributeGetCB Get(XaAttributeGetCB cb) {
	XaAttributeGetCB  ov = getCB; getCB = cb; return ov;}

    inline XaAttributeCheckCB Check() { return checkCB; }
    inline XaAttributeCheckCB Check(XaAttributeCheckCB cb) {
	XaAttributeCheckCB ov = checkCB; checkCB = cb; return ov; }
    
    inline XaTag Type() { return attribute.type;}
    inline XaTag Type(XaTag t) {
	XaTag ov = attribute.type; attribute.type = t; return ov; }

    inline XaTag Name() { return attribute.name; }
    inline XaTag Name(XaTag t) {
	XaTag ov  = attribute.name; attribute.name = t; return ov; }
    
    inline XaClassAttribute *ClassAttribute() { return classAttr; }

    /* Collectability */
    virtual unsigned hash(void) const;
    virtual XaBoolean equals(const XaCollectable &p) const;
    
private:
    
    friend class XaObject;
    
    XaAttributeCBData attribute;
    XaAttributeSetCB setCB;
    XaAttributeGetCB getCB;
    XaAttributeCheckCB checkCB;
    XaClassAttribute *classAttr;
};

class XaObject : public XaCollectable {

public:
    
    /* Life Cycle */
    XaObject(XaConnection *, XaClass *, XaTag objectTag, XaTag classID, 
	    XaTag name);
    XaObject(XaTag objectTag);
    ~XaObject();

    /*
     * Interface used by the protocol get/set requests
     * this implements the check/validate/set protocol.
     * attrs = an array of XaAttributeCBData structs.
     * count = tne number of CBData structs.
    */
    XaErrorCode SetAttribute(XaConnection *ca, XaAttributeCBData *attr);
    XaErrorCode SetAttributes(XaConnection *ca, 
			      XaAttributeCBData *attrs,
			      CARD32 count);
    /*
     * Returns the cached value.
     * Note: For arrays, the value returned is a copied pointer
     *       so do not destroy the memory value in the returned cbdata.
     */
    XaErrorCode GetAttribute(XaConnection *ca, XaAttributeCBData *attr);
    XaErrorCode GetAttributes(XaConnection *ca, 
			      XaAttributeCBData *attrs,
			      CARD32 count);

    /*
     * Returns a bag of XaStrings which are all
     * of the attribute names in the object.
     * 
     * NOTE:The client of this routine should manage all
     * memory in the returned bag.
     * Thus before deleting the bag, do a Bag::clearAndDelete()
     * on it.
    */
    XaBag *GetAttributeNames(void) const;

    /*
     * Install and remove attributes into the object
     * Usually used by subclasses at create time.
    */
    XaErrorCode AddAttribute(XaTag name, XaAttribute *attr);
    XaErrorCode AddAttribute(XaTag name, XaClassAttribute *ca, XaTag type,
			 void *defaultValue = NULL);
    XaErrorCode RemoveAttribute(XaTag name);

    /* Callback fetch or change */
    inline XaAttributeValidateCB Validate(XaAttributeValidateCB cb) {
	XaAttributeValidateCB ov = validate; validate = cb; return ov; }
    inline XaAttributeValidateCB Validate(void) { return validate; }

    XaAttributeSetCB   AttributeSetCB  (XaTag name, XaAttributeSetCB   newCB);
    XaAttributeGetCB   AttributeGetCB  (XaTag name, XaAttributeGetCB   newCB);
    XaAttributeCheckCB AttributeCheckCB(XaTag name, XaAttributeCheckCB newCB);

    /* Class operations */
    virtual XaBoolean IsWritable() { /* These two get overwritten */
	return XaFalse; }
    virtual XaBoolean IsReadable() { /* in the buffer superclass */
	return XaFalse; }
    
    XaBoolean ClassMatch(XaTag type);	/*matching class or superclass*/
    inline XaTag Class() { return classID; }
    inline XaClass *ClassObject() { return classObject; }

    /* Collectability */
    virtual XaBoolean equals(const XaCollectable &p) const;
    virtual unsigned hash(void) const;

    /*
     * jn: Return an XaAttribute for this name.
     *     Needed to get an attribute * from a device* from C.
     */
    XaAttribute *find(XaTag name);

    XaBoolean PullTriggers(XaAtom typeOccurred,
			   XaAttributeCBData **attrCBStructs,
			   CARD32 noOfAttr);

    /*
     * Add/Delete monitor from monitors bag.
     */
    XaErrorCode AddMonitor(XaTag monTag);
    XaErrorCode RemoveMonitor(XaTag monTag);

    /* Useful Other things */
    inline XaTag Tag(void) { return theTag; }
    inline void *ImplData() { return implData; }
    inline void *ImplData(void *newData) { 
	    void *oldData = implData; implData = newData; return oldData; }
    inline XaConnection *Conn() { return conn; }
    //virtual const char *printString();
    //virtual const char *debugString();
    inline XaAttribute* AtomToAttribute(XaTag name) 
    {
	return (XaAttribute *)attributes.find((unsigned)name); 
    }
    
protected:
    friend class XaClass;

    XaErrorCode localGetAttr(XaAttributeCBData *cata);
    XaAttributeValidateCB validate;

    /*
     * Instance storage for attribute records
     * keyed on AttributeTags.
    */
    XaScalarBag attributes;
    XaTag classID;
    XaClass *classObject;
    XaTag theTag;
    XaScalarBag monitors;	// XXXShould be XaAtomBag?
    XaTag theName;
    XaConnection *conn;
    void *implData; // implementation data - dia & dda must share this
};
#endif
