/* $XConsortium: monitor.cc /main/5 1996/12/30 16:30:34 swick $ */
/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/
/*
Copyright (c) 1996  The Santa Cruz Operation, Inc.

The X Consortium, and any party obtaining a copy of these files
from the X Consortium, directly or indirectly, is granted, free
of charge, a full and unrestricted irrevocable, world-wide,
paid up, royalty-free, nonexclusive right and license to deal in this
software and documentation files (the "Software"), including
without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicence, and sell copies of the Software, and to
permit persons who receive copies from any such party to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

SCO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL SCO BE LIABLE FOR ANY SPECIAL, INDIRECT,
PUNITIVE, CONSEQUENTIAL OR INCIDENTAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, LOSS OF DATA OR LOSS OF
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/

//
// XaMonitor provides the mechanism to generate events based on specified
// interest in server state changes.
//

#include "monitor.h"
#include "class.h"
#include "object.h"
#include "ctag.h"  //XXX temporarily here because XaScalarBags are used.
#include "condition.h"

void *MonitorClassCreate(void *conn, void *c, XaTag t1, XaTag t2, XaTag t3);

XaAttrInitRec XaMonitorAttrInit[] =
{
    { 
        XaNeventType,        	XaNatom,
                                XaValid,        // XXX need validation fxn
                                (void *)XaAeventChange,
                                XaMODE_CG
    },
    {
        XaNobjects,	  	XaNcard32,	// XXX need a tagbag here
                                XaValid,	// XXX need validation fxn
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    { 
        XaNactive,    		XaNbool,
                                XaValidBool,
                                (void *)XaTrue,
                                XaMODE_CSG
    },
    {
        XaNchanges,  		XaNcard32,	// XXX need an atombag here
                                XaValidAttributes, 
                                (void *)XaTnone, // XXX empty collection?
                                XaMODE_CSG
    },
    {
        XaNconditions,  	XaNcard32,	// XXX need an atombag here
                                XaValidConditions,
                                (void *)XaTnone, // XXX empty collection?
                                XaMODE_CSG
    },
    {
        XaNfilters,  		XaNcard32,	// XXX need an atombag here
                                XaValidConditions,
                                (void *)XaTnone, // XXX empty collection?
                                XaMODE_CSG
    },
    {
        XaNretAttributes,  	XaNcard32,	// XXX need an atombag here
                                XaValidAttributes,
                                (void *)XaTnone, // XXX empty collection
                                XaMODE_CSG
    }
};

XaClassInitRec XaMonitorClassInit =
{
    XaNmonitor, XaNobject,
    MonitorClassCreate,
    XaNumber(XaMonitorAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XaMonitor::CreateCB, XA_NULL, XA_NULL, XA_NULL, XA_NULL
};


XaMonitor::XaMonitor(XaConnection *c, XaClass *cl, XaTag objectTag,
  XaTag cid, XaTag name) : XaObject(c, cl, objectTag, cid, name)
{
}


XaMonitor::~XaMonitor()
{
    XaBagIterator  objectsI(objects);
    XaTag          objTag;
    XaCTag        *objCTag;
    XaConnection  *c = this->Conn();

    //
    // Iterate through the 'objects' list for this monitor object.
    //   Remove this monitor object from the 'monitors' list for each object.
    //
    while (objCTag = (XaCTag *)objectsI())
    {
        XaObject *object = (XaObject *)c->ObjectDB().find(*objCTag);
        if (object)
            object->RemoveMonitor(this->Tag());
    }
}


void 
XaMonitor::changesSetCB(void *obj, XaAttributeCBData *cbd) 
{
    XaMonitor 	       *mon = (XaMonitor *)obj;
    XaAtom    	       *newChanges = (XaTag *)cbd->newValue;
    XaAtom	       *oldChanges;
    XaConnection       *c = mon->Conn();
    XaCTag	       *ctag;
   
    //
    // Remove all attributes in the current XaNchanges attr
    // for this monitor.
    //
    oldChanges = (XaAtom *)cbd->value;
    if (oldChanges != NULL)
    {
        int i = 0;

        while (oldChanges[i])
        {
            mon->changes.removeAndDestroy((XaTag)oldChanges[i]);
            i++;
        }
    }
    
    //
    // Add all the new attributes in changes
    // for this monitor.
    // XXX: this function can be faster by
    //      only removing/inserting those attributes
    //	that apply.
    //
    if (newChanges != NULL)
    {
        int i = 0;

        while (newChanges[i])
        {
            ctag = new XaCTag(newChanges[i]);
            mon->changes.insert(*ctag);
            i++;
        }
    }
}


void 
XaMonitor::objectsSetCB(void *obj, XaAttributeCBData *cbd) 
{
    XaMonitor 	      *mon = (XaMonitor *)obj;
    XaTag             *newObjs = (XaTag *)cbd->newValue;
    XaTag	      *oldObjs;
    XaConnection      *conn = mon->Conn();
    XaObject	      *object;

    //
    // Iterate through current 'objects' list.
    //   Remove this monitor from objects[i]
    //   Remove objects[i] from this monitor
    //
    oldObjs = (XaTag *)cbd->value;
    if (oldObjs)
    {
        int  i = 0;

        while (oldObjs[i])
        {
	    // This may need to look at client objectDB also.
            object = (XaObject *)conn->ObjectDB().find(oldObjs[i]);
            if (object)
                object->RemoveMonitor(mon->Tag());

            mon->objects.removeAndDestroy(oldObjs[i]);
            i++;
        }
    }

    //
    // Iterate through new 'objects' list
    //   Add this monitor to objects[i]  
    //   Add objects[i] to this monitor.
    //
    if (newObjs)
    {
        int i = 0;

        while (newObjs[i])
        {
            object = (XaObject *)conn->ObjectDB().find(newObjs[i]);
            if (object)
                object->AddMonitor(mon->Tag());
        
            XaCTag *ctag = new XaCTag(object->Tag());
            mon->objects.insert(*ctag);
            i++;
        }
    }
}


XaErrorCode
XaMonitor::CreateCB(XaObject *obj, XaAttributeCBData * data, CARD32 count)
{
    XaMonitor   *mon = (XaMonitor *)obj;
    //
    // Set a Set Callback for the 'changes' attribute.
    //
    XaAttribute *attr = (XaAttribute *)mon->attributes.find(XaAchanges);
    if (attr) 
        attr->Set(XaMonitor::changesSetCB);
    else
        return XaEFailure;

    //
    // Set a Set Callback for the 'objects' attribute.
    //
    attr = (XaAttribute *)mon->attributes.find(XaAobjects);
    if (attr) 
        attr->Set(XaMonitor::objectsSetCB);
    else
        return XaEFailure;

    return XaESuccess;
}


void *
MonitorClassCreate(void *conn, void *c, XaTag t1, XaTag t2, XaTag t3)
{
    return (void*) new XaMonitor((XaConnection*)conn, (XaClass*)c, t1, t2, t3);
}


XaErrorCode XaCreateClassMonitor(XaConnection *conn)
{
    return (new XaClass(conn, XaAmonitor,
	    &XaMonitorClassInit, XaMonitorAttrInit)) ? XaESuccess : XaEFailure;
}


//
// Called for each monitor on an object.
//
XaBoolean
XaMonitor::Trigger(XaObject *obj, XaAtom typeOccurred,
		   XaAttributeCBData **attrs, CARD32 attrCount)
{
    int i;
    XaBoolean sendingEvent = XaFalse;
    XaBoolean pass;
    XaScalarBagIterator conditionIterator(conditions);
    XaCondition *condition;
    XaScalarBagIterator filterIterator(filters);
    XaCondition *filter;

    // check if the monitor is active
    if (!active)
	return(XaFalse);

    // check if we're monitoring this object
    if (!objects.contains(obj->Tag()))
 	return(XaFalse);

    // check if it's the right type of event
    if (eventType != typeOccurred)
	return(XaFalse);

    // XXX handle create/destroy events

    for (i = 0; i < attrCount; i++)
    {
    	if (changes.contains(attrs[i]->name))
	{
    	    // evaluate conditions to determine if any are met
	    while (!sendingEvent &&
	      (condition = (XaCondition *)conditionIterator()))
	    {
    	        if (condition->Evaluate(attrs[i]))
    	        {
		    pass = XaTrue;
		    // all filters must be passed to send an event
	            while (pass && (filter = (XaCondition *)filterIterator()))
	            {
		        if (!filter->Evaluate(attrs[i]))
		        {
			    pass = XaFalse;
			}
		    }

		    if (pass)
	    	        sendingEvent = XaTrue;
		    else
			filterIterator.reset();
	        }
	    }

	    if (!sendingEvent)
	        conditionIterator.reset();
	}
    }

    if (sendingEvent)
    {
	// XXX send event (retAttributes)
	return(XaTrue);
    }
    else
    	return(XaFalse);
}

