/* $XConsortium: condition.cc /main/3 1996/12/30 16:30:23 swick $ */
/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/
/*
Copyright (c) 1996  The Santa Cruz Operation, Inc.

The X Consortium, and any party obtaining a copy of these files
from the X Consortium, directly or indirectly, is granted, free
of charge, a full and unrestricted irrevocable, world-wide,
paid up, royalty-free, nonexclusive right and license to deal in this
software and documentation files (the "Software"), including
without limitation the rights to use, copy, modify, merge,
publish, distribute, sublicence, and sell copies of the Software, and to
permit persons who receive copies from any such party to do so,
subject to the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

SCO DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
IN NO EVENT SHALL SCO BE LIABLE FOR ANY SPECIAL, INDIRECT,
PUNITIVE, CONSEQUENTIAL OR INCIDENTAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, LOSS OF DATA OR LOSS OF
PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
*/

//
// XaCondition tests for changes in an object.
//

#include "condition.h"
#include "class.h"
#include "object.h"

XaAttrInitRec XaConditionAttrInit[] =
{
    { 
        XaNattribute,           XaNatom,
                                XaValid,        
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    { 
        XaNcomparison,          XaNatom,
                                XaValid,        
                                (void *)XaTnone,
                                XaMODE_CSG
    },
    { 
        XaNonTransition,    	XaNbool,
                                XaValidBool,
                                (void *)XaFalse,
                                XaMODE_CSG
    },
    {
        XaNreference,  		XaNint32,	// XXX XaNpointer?
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    },
    {
        XaNdelta,  		XaNint32,	// XXX XaNpointer?
                                XaValid,
                                (void *)0,
                                XaMODE_CSG
    }
};


XaCondition::XaCondition(XaConnection *c, XaClass *cl, XaTag objectTag,
  XaTag classID, XaTag name) : XaObject(c, cl, objectTag, classID, name)
{
}


XaCondition::~XaCondition()
{
}


XaClassInitRec XaConditionClassInit =
{
    XaNcondition, XaNobject,
    NULL,
    XaNumber(XaConditionAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XA_NULL, XA_NULL, XA_NULL, XA_NULL, XA_NULL
};


XaErrorCode XaCreateClassCondition(XaConnection *conn)
{
    return (new XaClass(conn, XaAcondition,
	    &XaConditionClassInit, XaConditionAttrInit)) ? XaESuccess :
	    XaEFailure;
}


XaBoolean XaCondition::Evaluate(XaAttributeCBData *attr)
{
    INT32 difference;
    INT32 multiplier;
    XaBoolean evaluation;
    static XaBoolean lastEvaluation = XaFalse;

    if (!attribute == attr->name)
	return(XaFalse);
    
    // XXX need to handle non numerics seperately?

    // XXX modulo N arithmetic ?
    difference = (INT32)attr->newValue - reference;

    switch(comparison)
    {
      case XaAnegative:
	if (difference < 0)
	    evaluation = XaTrue;
	else
	    evaluation = XaFalse;
	break;
      case XaApositive:
	if (difference > 0)
	    evaluation = XaTrue;
	else
	    evaluation = XaFalse;
	break;
      case XaAequal:
	if (difference == 0)
	    evaluation = XaTrue;
	else
	    evaluation = XaFalse;
	break;
      case XaAnotEqual:
	if (difference != 0)
	    evaluation = XaTrue;
	else
	    evaluation = XaFalse;
	break;
    }

    if (onTransition && evaluation)
	evaluation = !lastEvaluation;

    lastEvaluation = evaluation;

    if (evaluation)
    {
	if (delta != 0)
	{
	    multiplier = difference / delta + (difference % delta ? 1 : 0);
	    reference += delta * multiplier;
	}
    	return(XaTrue);
    }

    return(XaFalse);
}
