/* $XConsortium: class.h /main/7 1996/12/30 16:30:17 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#ifndef __class_h
#define __class_h

/*
** this file conatains the object definition classes.  Each instance of XaClass
** defines a class for our client visible object model. XaClass uses an instance
** of XaClassAttribute for each attribute of the class. Code that wishes to
** define a new class uses XaClassInitRec and XaAttrInitRec in calling the
** XaClass Constructor. (Note: these two structs will get moved to a "C"
** include eventually.)
*/

#include <stdio.h>
#include <stdarg.h>
#include <Xa/atomdefs.h>
#include <Xa/atomstrings.h>
#include "object.h"
#include "ctag.h"
#include "cclass.h"

class XaObject;
class XaAttribute;

#include "connection.h"

/* 
** macro to call function pointer only if it has been set. Use like:
** 	XA_CALL_FP(fp)(param0, param1);
*/
#define XA_CALL_FP(funcPtr)	(!funcPtr) ? XaESuccess : (*(funcPtr))

/*
** The XaClassAttribute instance defines one attribute for a class,
** including the name, type and default of the class.
*/
class XaClassAttribute : public XaCollectable
{
  public:
    XaClassAttribute(XaAtom name, XaAtom type,  XaAttrInitPtr);
    XaClassAttribute(XaClassAttribute *);
    ~XaClassAttribute();

    XaAttribute *Create(void *value, XaBoolean useValue);
    inline XaErrorCode TypeCheck(XaObject *o, void *v) 
	    { return (*(detail.typeCheckCB))(o, v) ? XaESuccess : XaEFailure; }
    inline XaTag Name() { return aname; };

    /* Collectability */
    virtual unsigned hash(void) const;
    virtual XaBoolean equals(const XaCollectable &p) const;

  private:
    XaAttrInitRec	detail;
    XaAtom		aname;
    XaAtom		typeTag;
};

/*
** The XaClass class represents the definition and composition of an Xa class.
*/
class XaClass : public XaCollectable
{
  public:
    XaClass(XaConnection*, XaTag classTag, XaClassInitPtr initClass, 
	    XaAttrInitPtr initAttr);
    ~XaClass();

    /*AddAttribute must be not used when instances of the defined class exist!*/
    XaErrorCode AddAttribute(XaClassInitPtr init);

    /* Create an instance of this XaClass */
    XaObject *Create(XaConnection*, XaTag objectTag, XaTag name, 
	    XaAttributeCBData*, CARD32 count);

    XaBag *GetAttributeNames(void) const;
    inline XaClassAttribute *GetAttribute(XaTag);

    XaBoolean Match(XaTag);	/* match this class or its superclasses */

    /* Collectability */
    virtual XaBoolean equals(const XaCollectable &p) const;
    virtual unsigned hash(void) const;

    // need this so object can find the class object to send destroy events
    inline XaObject *ExtClassObject(void) { return extClassObject; }

    // ensure that this object has a valid external class object pointing back
    XaObject *EnsureExtClassObject(void);

  protected:
    friend class XaObject;

    /* 
    ** These call the class callbacks. XaClass calls the CreateCb directly.
    ** The others should be called by XaObject.
    */
    inline XaErrorCode 
	    CreateCB(XaObject *obj, XaAttributeCBData *data, CARD32 ndata)
	{ return XA_CALL_FP(init.createCB)(obj, data, ndata); }

    inline XaErrorCode 
	    CheckCB(XaObject *obj, XaAttributeCBData **data, CARD32 ndata)
	{ return XA_CALL_FP(init.checkCB)(obj, data, ndata); }

    inline XaErrorCode 
	    SetCB(XaObject *obj, XaAttributeCBData **data, CARD32 ndata) 
	{ return XA_CALL_FP(init.setCB)(obj, data, ndata); }

    inline XaErrorCode 
	    GetCB(XaObject *obj, XaAtom atoms, CARD32 natoms)
	{ return XA_CALL_FP(init.getCB)(obj, atoms, natoms); }

    inline XaErrorCode DestroyCB(XaObject *obj)
	{ return XA_CALL_FP(init.destroyCB)(obj); }

  private:
    XaScalarBag		attributes;
    XaClass		*super;
    XaClassInitRec	init;
    XaTag		tag;
    XaConnection	*conn;
    XaObject		*extClassObject; // This is the object from which
					// we hang monitors for this class
};

typedef XaErrorCode (XaCreateClassFunc)(XaConnection *);
/* 
** This is the routine used to create new class definitions
*/
extern XaObject *
XaCreateObject(XaConnection *conn, XaTag className, XaTag objectTag, XaTag name,
	    XaAttributeCBData*, CARD32 count);

class XaEnumerated
{
  public:
    XaEnumerated();
    ~XaEnumerated();
    inline void Add(XaAtom atom)	
	    { bag.insert(*(new XaCTag(atom))); };
    inline void Add(XaAtom *patom, CARD32 count) 
	    { while (count--) { cname = *patom; Add(*(patom++)); }};
    inline XaBoolean Valid(XaAtom name)
	    { cname = name; return (bag.find(cname) != XA_NULL); };
  private:
    XaBag bag;
    XaCTag cname;
};

inline XaBoolean XaValidType(XaObject *obj, void *tag, XaTag type)
{
    return (obj == (XaObject *)obj->Conn()->
	    ObjectDB().find((XaTag)(long)tag) && obj->ClassMatch(type));
}

#endif
