/* $XConsortium: class.cc /main/8 1996/12/30 16:30:14 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/


#include "class.h"

static void _Error() { printf("class.cc allocation failure!\n");}
#define ALLOC_FAIL _Error() /*XXX*/
/*
**********************************************************
** XaClassAttribute methods
*/

XaClassAttribute::XaClassAttribute(XaAtom n, XaAtom t, XaAttrInitPtr init):
	aname(n), typeTag(t)
{
    detail = *init;
    detail.name = XA_NULL;
    detail.type = XA_NULL;
}

XaClassAttribute::XaClassAttribute(XaClassAttribute *donor)
{
    aname = donor->aname;
    typeTag = donor->typeTag;
    detail = donor->detail;
}

XaClassAttribute::~XaClassAttribute() {}

XaAttribute *
XaClassAttribute::Create(void *v, XaBoolean useV)
{
    return (new XaAttribute(aname, this, (useV) ? v : detail.defaultValue, typeTag));
}
    
/* Collectability - all instances are unique */
unsigned XaClassAttribute::hash(void) const { return aname; }

XaBoolean XaClassAttribute::equals(const XaCollectable&p) const 
{ return aname == ((XaClassAttribute*)&p)->aname; }

/*
**********************************************************
** XaClass methods
*/

XaClass::XaClass(XaConnection *c, XaTag t, XaClassInitPtr initClass, 
	XaAttrInitPtr initAttr) : conn(c), tag(t)
{
    super = XA_NULL;
    init = *initClass;
    /* Lookup super class */
    if (initClass->super)
    {
	XaAtom asuper = conn->findAtom(initClass->super, XaFalse);
	if (asuper)
	    super = (XaClass *)c->ClassDB().find(asuper);
    }
    if (initClass->super && !super || !tag)
    {
	ALLOC_FAIL;
	return;
    }

    /* Create attributes for this class */
    CARD32 nattr = 0;
    XaAttrInitPtr pattr = initAttr; 
    for (; nattr < initClass->nattr; nattr++, pattr++)
    {
	/* lookup atoms for attribute name and type */
	XaAtom aname = conn->findAtom(pattr->name, XaTrue);
	XaAtom atype = conn->findAtom(pattr->type, XaTrue);
	if (!atype || !aname)
	    break;
	XaClassAttribute *tmpAttr = new XaClassAttribute(aname, atype, pattr);
	if (!tmpAttr)
	    break;
	else if (!attributes.insert(*tmpAttr))
	{
	    delete tmpAttr;
	    break;
	}
    }
    XaBoolean fail = nattr != initClass->nattr;
    /* copy in the attributes of the super class */
    if (super)
    {
	XaScalarBagIterator superAttrIter(super->attributes);
	XaClassAttribute *superAttr;
	while (!fail && (superAttr = (XaClassAttribute *)superAttrIter()))
	{
	    if (!attributes.contains(superAttr->Name()))
	    {
		XaClassAttribute *tmpAttr = new XaClassAttribute(superAttr);
		if (!tmpAttr || !attributes.insert(*tmpAttr))
		{
		    if (tmpAttr)
			delete tmpAttr;
		    fail = XaTrue;
		}
	    }
	}
    }

    /* chain to superclass callback if no callback specified */
    if (super)
    {
	if (!init.createCB)  init.createCB  = super->init.createCB;
	if (!init.checkCB)   init.checkCB   = super->init.checkCB;
	if (!init.setCB)     init.setCB     = super->init.setCB;
	if (!init.getCB)     init.getCB     = super->init.getCB;
	if (!init.destroyCB) init.destroyCB = super->init.destroyCB;
    }

    /* If we fail in creating attributes, clean up */
    if (fail || !c->ClassDB().insert(*this))
    {
	attributes.clearAndDelete();
	ALLOC_FAIL;
	return;
    }

    // create a class object on which we can hang monitors
    // XXX what should tag, name, data, and count be?
    XaAtom aname = conn->findAtom(initClass->name, XaFalse);
    // This initialization is needed because XaCreateObject() will
    // indirectly refer to extClassObject.
    extClassObject = NULL;
    extClassObject = XaCreateObject(conn, XaAclass, 0, aname, 0, 0);
}

XaClass::~XaClass() 
{ 
    attributes.clearAndDelete();
    conn->ClassDB().remove(this->tag);
}

XaObject *
XaClass::Create(XaConnection *c, XaTag objectTag, XaTag name,  
	XaAttributeCBData *data, CARD32 count)
{
    XaObject* object;
    XaBoolean fail = XaFalse;
    XaAttribute *instAttr;
    XaErrorCode  err;

    object = (!init.construct) ?
	    new XaObject(c, this, objectTag, tag, name) :
	    (XaObject *)(*(init.construct))( 
		    (void *)c, (void *)this, objectTag, tag, name);

    if (!object)
	return XA_NULL;

    if (!c->ObjectDB().insert(*object))
    {
	delete object;
	ALLOC_FAIL;
	return XA_NULL;
    }

    /* 
    ** For each attribute in the class, create an instance attribute 
    */
    XaScalarBagIterator classAttrIter(attributes);
    XaClassAttribute *classAttr;
    while (!fail && (classAttr = (XaClassAttribute *)classAttrIter()))
    {
	instAttr = classAttr->Create((void *)0, XaFalse);
	if (!instAttr)
	    fail = XaTrue;
	if (object->AddAttribute(classAttr->Name(), instAttr) != XaESuccess) 
	{
	    delete instAttr;
	    fail = XaTrue;
	}
    }
    if (fail)
    {
	delete object;
	return XA_NULL;
    }

    // Set the connection attribute of the object
    {
	XaAttributeCBData cbdata;
	cbdata.name = XaAconnection;
	cbdata.value = (void *)c->Tag();
	object->SetAttribute(c, &cbdata);
    }

    err = CreateCB(object, data, count);/* XXX worry about return value? */
    if (err != XaESuccess)
    {
	delete object;
	return XA_NULL;
    }

    // Ensure that we have an external class object to work with
    if (name != XaAclass)
	EnsureExtClassObject();
    
    // Send any create events
    if (extClassObject)
	extClassObject->PullTriggers(XaAeventCreate, 0, 0);

    return object;
}


// ensure that this object has a valid external class object pointing back
XaObject *
XaClass::EnsureExtClassObject(void)
{
    if (extClassObject == NULL)
	extClassObject = XaCreateObject(conn, XaAclass, 0,
					conn->findAtom(init.name, XaFalse),
					0, 0);
    return extClassObject;
}

/* Copy all of the names into the new bag. */
XaBag *XaClass::GetAttributeNames(void) const 
{
    XaBag *names = new XaBag;
    if (!names)
    {
	ALLOC_FAIL;
	return XA_NULL;
    }
    XaScalarBagIterator attributesI(attributes);
    XaClassAttribute *attr;
    while(attr = (XaClassAttribute *)attributesI()) {
        XaCTag *newName = new XaCTag(attr->Name());
	if (!newName || !names->insert(*newName))
	{
	    if (newName)
		delete newName;
	    names->clearAndDelete();
	    ALLOC_FAIL;
	    return XA_NULL;
	}
    }

    return names;
}

XaClassAttribute *XaClass::GetAttribute(XaTag name)
{
    return ((XaClassAttribute*)attributes.find(name));
}

/* return true if this class or a superclass matches the tag */
XaBoolean XaClass::Match(XaTag tname)
{
    for (XaClass *cl = this; cl; cl = cl->super)
	if (tname == cl->tag)
	    return XaTrue;
    return XaFalse;
}

/* Collectability - all instances are unique */
unsigned XaClass::hash(void) const { return tag; }

XaBoolean XaClass::equals(const XaCollectable&p) const 
{
    return tag == ((XaClass*)&p)->tag;
}

XaObject *
XaCreateObject(XaConnection *conn, XaTag className, XaTag objectTag, XaTag name,
	    XaAttributeCBData *data, CARD32 count)
{
    XaClass *classObject = (XaClass *)conn->ClassDB().find(className);
    return (classObject) ? 
	    classObject->Create(conn, objectTag, name, data, count) : XA_NULL;
}
    
/* ----------------------------------------------
** define types and their vaildation routines
*/
XaEnumerated::XaEnumerated() {}
XaEnumerated::~XaEnumerated() { bag.clearAndDelete(); }

XaBoolean XaValid(XaObject *obj, void *v) { return XaTrue; }
XaBoolean XaValidBool(XaObject *obj, void *v) 
{ return ((XaBoolean)(long)v == XaTrue || (XaBoolean)(long)v == XaFalse); }

XaBoolean XaValidClass(XaObject *obj, void *in) 
{
    return (obj->Conn()->ClassDB().contains((XaTag)(long)in));
}

XaBoolean XaValidString(XaObject *obj, void *tag)	  
	{ return (tag) ? XaValidType(obj, tag, XaAobject) : XaTrue; }
/* XXX the above type should not be XaTobject!!! */

inline XaBoolean XaValidAccess(XaObject *obj, void *tag)
    { return (tag) ? XaValidType(obj, tag, XaAcondition) : XaTrue; }

XaBoolean XaValidAccesses(XaObject *obj, void *tag)
{
    // XXX should handle collection!!!
    return XaValidAccess(obj, tag);
}

inline XaBoolean XaValidMonitor(XaObject *obj, void *tag)
	{ return (tag) ? XaValidType(obj, tag, XaAmonitor) : XaTrue; }

XaBoolean XaValidMonitors(XaObject *obj, void *tag)
{ 
    // XXX should handle collection!!!
    return XaValidMonitor(obj, tag);
}

inline XaBoolean XaValidCondition(XaObject *obj, void *tag)
    { return (tag) ? XaValidType(obj, tag, XaAcondition) : XaTrue; }

XaBoolean XaValidConditions(XaObject *obj, void *tag)
{
    // XXX should handle collection!!!
    return XaValidCondition(obj, tag);
}

inline XaBoolean XaValidAttribute(XaObject *obj, void *tag)
    { return (tag) ? XaValidType(obj, tag, XaAattribute) : XaTrue; }

XaBoolean XaValidAttributes(XaObject *obj, void *tag)
{
    // XXX should handle collection!!!
    return XaValidAttribute(obj, tag);
}

