/* $XConsortium: cclass.h /main/7 1996/12/30 16:30:11 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

#ifndef __cclass_h
#define __cclass_h

#include "cobject.h"
/* XXXX These two defines should be elsewhere!XXXXXXX */
typedef XaTag XaAtom;
#define XA_NULL 0


#ifdef __cplusplus
extern "C" {
#endif

/* Access modes as used in the class definition tables */
#define XaMODE_NONE	0
#define XaMODE_M	(1 << 0)	/* Set Mandatory on create */
#define XaMODE_C	(1 << 1)	/* Create */
#define XaMODE_S	(1 << 2)	/* Set */
#define XaMODE_S_ON_T	(1 << 3)	/* Set on object of trusted clients */
#define XaMODE_S_BY_T	(1 << 4)	/* Set by trusted clients */
#define XaMODE_G	(1 << 5)	/* Get */
#define XaMODE_CG	(XaMODE_C | XaMODE_G)
#define XaMODE_SG	(XaMODE_S | XaMODE_G)
#define XaMODE_CSG	(XaMODE_C | XaMODE_SG)

/* XaNumber gives the number of elements in a static array */
#define XaNumber(array)	(sizeof(array) / sizeof(array[0]))

typedef XaBoolean 	(XaTypeCheckFunc)(XaObject *, void *v);
typedef XaTypeCheckFunc	*XaTypeCheckFuncPtr;

/*
** XaAttrInitRec is used to described an attribute when constructing 
** instance of XaClass.
*/
typedef struct _XaAttrInitRec 
{
    char *	name;
    char *	type;
    XaTypeCheckFuncPtr 	typeCheckCB;
    void	*defaultValue;
    CARD32	access;
  /*destructor	dest;		? */
} XaAttrInitRec, *XaAttrInitPtr;

/* 
** XXX this is wrong, since C extensions can not deal with function pointers
** containing C++ parameters.
** XXX the callback signatures should be fixed.
*/
typedef XaErrorCode (XaClassCreateFunc)(XaObject*, XaAttributeCBData * data,
					CARD32 count);
typedef XaErrorCode (XaClassCheckFunc)(XaObject*,
				       XaAttributeCBData **, CARD32 ndata);
typedef XaClassCheckFunc XaClassSetFunc;
typedef XaErrorCode (XaClassGetFunc)(XaObject*, XaAtom, CARD32);
typedef XaErrorCode (XaClassDestroyFunc)(XaObject*);
typedef void *(*XaObjectConstructor)(void *, void *, XaTag, XaTag, XaTag);

typedef XaClassCreateFunc	*XaClassCreateCB;
typedef XaClassCheckFunc	*XaClassCheckCB;
typedef XaClassSetFunc		*XaClassSetCB;
typedef XaClassGetFunc		*XaClassGetCB;
typedef XaClassDestroyFunc	*XaClassDestroyCB;
/*
** XaClassInitRec is used when constucting a new instance of XaClass
*/
typedef struct _XaClassInitRec 
{
    char		*name;
    char		*super;			/* super class name */
    XaObjectConstructor construct;		/* XA_NULL for default */
    CARD32		nattr;			/* # of attributes */
    CARD32		trustedAccess;		/* access by trusted clients */
    CARD32		untrustedAccess;	/* access by untrusted clients*/
    /*
    ** The following callbacks are intended for device-independent 
    ** behavior
    */
    XaClassCreateCB	createCB;
    XaClassCheckCB	checkCB;
    XaClassSetCB	setCB;
    XaClassGetCB	getCB;
    XaClassDestroyCB	destroyCB;	/*also need read/write?*/
} XaClassInitRec, *XaClassInitPtr;

/*
** These are the common attribute validation routines..
*/
XaBoolean 	XaValid(XaObject *, void *v);	/* always true */
XaBoolean 	XaValidBool(XaObject *, void *v);
XaBoolean 	XaValidClass(XaObject *, void *v);
XaBoolean 	XaValidString(XaObject *, void *v);
XaBoolean 	XaValidMonitors(XaObject *, void *v);
XaBoolean 	XaValidConditions(XaObject *, void *v);
XaBoolean 	XaValidAccesses(XaObject *, void *v);
XaBoolean 	XaValidAttributes(XaObject *, void *v);

#ifdef __cplusplus
}
#endif

#endif
