/* $XConsortium: format.cc /main/5 1996/12/30 16:30:05 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/


/*
** Format Class definition
*/

#include "class.h"

XaEnumerated *XaEncodings;
XaAtom XaInitialEncodings[] = { XaAencodeLinear, XaAencodeUlaw, XaAencodeAlaw };
XaBoolean XaValidEncoding(XaObject *obj, void *atom) 
	{ return XaEncodings->Valid((XaAtom)(unsigned long)atom); }

#define FMT_DEFAULT_ENCODING        XaAencodeUlaw
#define FMT_DEFAULT_ENDIAN          XaTrue
#define FMT_DEFAULT_NUM_CHANS       1
#define FMT_DEFAULT_SAMPLE_WIDTH    8
#define FMT_DEFAULT_SAMPLE_RATE     8000

static XaAttrInitRec XaFormatAttrInit[] =
{
    { 
	XaNencoding,		XaNatom,   
				XaValidEncoding,	
	    			(void *)FMT_DEFAULT_ENCODING, 
				XaMODE_M | XaMODE_CSG
    },
    {
	XaNbigEndian,		XaNbool,   
				XaValidBool,
				(void *)FMT_DEFAULT_ENDIAN,
				XaMODE_CSG
    },
    { 
	XaNnumChannels,		XaNcard32,
				XaValid,
				(void *)FMT_DEFAULT_NUM_CHANS,
				XaMODE_CSG
    },
    {
	XaNbitsPerSample,	XaNcard32,
				XaValid,
				(void *)FMT_DEFAULT_SAMPLE_WIDTH,
				XaMODE_CSG
    },
    {
	XaNsampleRate,		XaNcard32,
				XaValid,
				(void *)FMT_DEFAULT_SAMPLE_RATE,
				XaMODE_CSG
    }
};

static XaClassInitRec XaFormatClassInit = 
{
    XaNformat, XaNobject, 
    XA_NULL,
    XaNumber(XaFormatAttrInit),
    XaMODE_CSG, XaMODE_CSG,
    XA_NULL, XA_NULL, XA_NULL, XA_NULL, XA_NULL 
};

XaErrorCode XaCreateClassFormat(XaConnection *conn)
{
    XaEncodings = new XaEnumerated;
    XaEncodings->Add(XaInitialEncodings, XaNumber(XaInitialEncodings));
    return (new XaClass(conn, XaAformat, 
	    &XaFormatClassInit, XaFormatAttrInit)) ? XaESuccess : XaEFailure;
}
