/* This line lets emacs recognize this as -*- C -*- Code */
/* $XConsortium: errors.h /main/4 1996/12/30 16:29:40 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/*
Copyright (c) 1996 Digital Equipment Corporation

Digital Equipment Corporation makes no representations about
the suitability of this Software for any purpose.  The Software
is provided "as is" without express or implied warranty.


@SUN_COPYRIGHT@

*/

#ifndef XA_ERRORS_H
#define XA_ERRORS_H

/* for synchronous error return values. */
typedef int	XaErrorCode;

/* Error types (new, temporary) */

#define XaESuccess		0   /*	success  */
#define XaEFailure		1   /*	Undifferentiated failure
					(not defined in protocol/API spec)  */

#define XaEAlloc		2   /*	Allocation error (create or reply)  */
#define XaETag			3   /*	Invalid tag  */
#define XaEClass		4   /*	Object passed is of invalid class  */
#define XaEName			5   /*	Invalid class/attribute name(s)  */
#define XaEValue		6   /*	Value not of correct type or range  */
#define XaEAccess		7   /*	Permission denied  */
#define XaEAtom			8   /*	Invalid atom  */

#define XaEUnimplemented	9   /*  Requested operation is unimplemented */

#define XaEServerInternal       10   /*  Problem in the server implementation
				        (this is a "should not happen" error */


/* Basic errors (converted XAL code) */
#define XA_SUCCESS      	0
#define XA_FAILURE      	1  /*Error String: Operation failed*/
#define XA_OUT_OF_MEMORY	2  /*Error String: Out of Memory*/
#define XA_NO_SYSTEM_STATE	3  /*Error String: NULL or invalid XaSystemState*/
#define XA_INVALID_NULL_ARG	4  /*Error String: Invalid NULL argument*/
#define XA_INVALID_RANGE	5  /*Error String: Parameter out of range*/
#define XA_SIGN_ERROR		6  /*Error String: Parameter passed is of incorrect sign*/
#define XA_EOS 			7  /*Error String: The end of an audio stream has been encountered. No more audio data will be sent for an unknown period of time.*/

/* This is for the C API only */
#define XA_CANT_LOCK_OBJECT	9  /*Error String: Couldn't lock object*/
#define XA_WRONG_PARAMETER 	10 /*Error String: An incorrect parameter type was passed, usually the wrong object type.*/
#define XA_INVALID_TYPE_ARG 	11 /*Error String: The wrong object type was passed.*/
#define XA_CANT_COPY      	12 /*Error String: Can't copy object.*/
#define XA_UNKNOWN_MESSAGE	13 /*Error String: An unknown message was received.*/
#define XA_NO_DEFAULT     	14 /*Error String: There is no default value. */
#define XA_NOT_IMPLEMENTED	15 /*Error String: The xal call being made is not yet implemented. */

#define MAX_ERRORS_PER_CLASS 100
#define XA_ERROR_BASE(classId)    ((classId - XA_BASE + 1)*MAX_ERRORS_PER_CLASS)

/* enum for error categories */
typedef enum XaErrorCategory {
   XA_ERROR_SYSTEM,
   XA_ERROR_RESOURCE,
   XA_ERROR_ARITHMETIC,
   XA_ERROR_USER,
   XA_ERROR_CONFIGURATION,
   XA_ERROR_DATA,
   XA_ERROR_OTHER
} XaErrorCategory;

#endif /* XA_ERRORS_H */
