/* $XConsortium: connection.h /main/5 1996/12/30 16:29:28 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

// 
// Copyright (c) 1996 Digital Equipment Corporation
// 
// Digital Equipment Corporation makes no representations about
// the suitability of this Software for any purpose.  The Software
// is provided "as is" without express or implied warranty.
//
// HISTORY
// 
// @(#)$RCSfile: connection.h $ $Revision: /main/5 $ (DEC) $Date: 1996/12/30 16:29:28 $
// 

#ifndef CONNECTION_H
#define CONNECTION_H

#include <X11/ICE/ICElib.h>
#include <Xa/Xaprotocol.h>
#include "atom.h"
#include "object.h"

class XaScalarBag;

class XaConnection
{
  protected:

    friend class    XaScheduler;
    friend class    XaMasterConnection;
    friend class    XaClientConnection;

    int             iceOpCode;
    IceConn         connectionId;
    char            *vendorString;
    char            *releaseString;
    XaObject	    *externalObj;

    XaAtomCache     atomCache;

    XaConnection();
  public:
    XaAtomCache &AtomCache() { return atomCache; }

    virtual XaAtom	findAtom(char *name, XaBoolean create) = 0;

    // The following refer to local objects and tags
    virtual XaScalarBag	&ObjectDB() = 0;
    virtual XaScalarBag	&ClassDB() = 0;

    virtual void 	ReleaseTag(XaTag tag) = 0;
    
    virtual XaConnection * Narrow(const char * className) = 0;
    static void 	Swap32(CARD32 *, int length);
    inline XaTag	Tag() {
		return ((externalObj) ? externalObj->Tag() : XaTnone); }
};

class XaProtoBuffer
{
  private:

    int  lockLevel;
    int  stackSize;
    int	 *bufSize;
    char **bufferStack;
    char **bufPtr;
    int	 *protoLength;
    void Grow(int size);
    void GrowStack();

  public:

    XaProtoBuffer();
    ~XaProtoBuffer();

    void Write(char *data, int length);
    char *Reserve(int length);
    void Reset();
    void Lock();
    void Unlock();
    inline char *Buffer()	{ return bufferStack[lockLevel]; }
    inline char *BufferPtr()	{ return bufPtr[lockLevel]; }
    inline int  ProtoLength()	{ return protoLength[lockLevel]; }
};

class XaProtocolConnection : public XaConnection
{
protected:
    XaProtoBuffer protocolBuffer;
    XaProtoBuffer parseBuffer;

    XaArgVal parseParamList(XaProtoItem *itemList, int length, int& attrCount,
				XaBoolean makeArgList = False);


};

/*
 * This is intended to be used in place of IceWritePad.  It makes sure that
 * padding is null.  Used to force 32 or 64 bit alignment.
 * A maxium of 7 pad bytes can be specified.
 */

#define _XaWritePad(_iceConn, _bytes) \
{ \
    CARD32 _dummy[2]; \
    _dummy[0] = 0;\
    _dummy[1] = 0;\
    IceWriteData(_iceConn, _bytes, (char *)_dummy); \
}

#endif /* CONNECTION_H */
