/* $XConsortium: au.h /main/3 1996/12/30 16:29:09 swick $ */

/*
Copyright (c) 1996  X Consortium

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall
not be used in advertising or otherwise to promote the sale, use or
other dealings in this Software without prior written authorization
from the X Consortium.
*/

/* Copyright (c) 1992 by Sun Microsystems, Inc. */

#ifndef _AU_H
#define	_AU_H


/*
 * Define an on-disk audio file header.
 *
 * This structure should not be arbitrarily imposed over a stream of bytes,
 * since the byte orders could be wrong.
 *
 * Note that there is an 'info' field that immediately follows this
 * structure in the file.
 *
 * The hdr_size field is problematic in the general case because the
 * field is really "data location", which does not ensure that all
 * the bytes between the header and the data are really 'info'.
 * Further, there are no absolute guarantees that the 'info' is ASCII text,
 * (non-ASCII info may eventually be far more useful anyway).
 *
 * When audio files are passed through pipes, the 'data_size' field may
 * not be known in advance.  In such cases, the 'data_size' should be
 * set to AUDIO_UNKNOWN_SIZE.
 */
typedef struct {
	unsigned 	magic;		/* magic number */
	unsigned 	hdr_size;	/* size of this header */
	unsigned 	data_size;	/* length of data (optional) */
	unsigned	encoding;	/* data encoding format */
	unsigned	sample_rate;	/* samples per second */
	unsigned	channels;	/* number of interleaved channels */
} SunFileHeader;

/* Value used for indeterminate size (e.g., data passed through a pipe) */
#define AUDIO_UNKNOWN_SIZE      ((unsigned)(~0))

/* Define the au magic number */

#define AU_SUN_MAGIC       0x2e736e64              /* Really '.snd' */
#define AU_SUN_INV_MAGIC   0x646e732e              /* '.snd' upside-down */
#define AU_DEC_MAGIC       0x2e736400              /* Really '\0ds.' (for DEC) */
#define AU_DEC_INV_MAGIC   0x0064732e              /* '\0ds.' upside-down */


/* Define the encoding fields */
#define	AUDIO_FILE_ENCODING_MULAW_8	(1)	/* 8-bit ISDN u-law */
#define	AUDIO_FILE_ENCODING_LINEAR_8	(2)	/* 8-bit linear PCM */
#define	AUDIO_FILE_ENCODING_LINEAR_16	(3)	/* 16-bit linear PCM */
#define	AUDIO_FILE_ENCODING_LINEAR_24	(4)	/* 24-bit linear PCM */
#define	AUDIO_FILE_ENCODING_LINEAR_32	(5)	/* 32-bit linear PCM */
#define	AUDIO_FILE_ENCODING_FLOAT	(6)	/* 32-bit IEEE floating point */
#define	AUDIO_FILE_ENCODING_DOUBLE	(7)	/* 64-bit IEEE floating point */
#define	AUDIO_FILE_ENCODING_ADPCM_G721	(23)	/* 4-bit CCITT g.721 ADPCM */
#define	AUDIO_FILE_ENCODING_ADPCM_G722	(24)	/* CCITT g.722 ADPCM */
#define	AUDIO_FILE_ENCODING_ADPCM_G723_3 (25)	/* CCITT g.723 3-bit ADPCM */
#define	AUDIO_FILE_ENCODING_ADPCM_G723_5 (26)	/* CCITT g.723 5-bit ADPCM */
#define AUDIO_FILE_ENCODING_ALAW_8	(27) 	/* 8-bit ISDN A-law */


/*
 * These encoding types are
 * here because these are not defined
 * in <sys/audioio.h>
 */
#define AUDIO_ENCODING_FLOAT    (100)   /* IEEE float (-1. <-> +1.) */
#define AUDIO_ENCODING_G721     (101)   /* CCITT g.721 ADPCM */
#define AUDIO_ENCODING_G722     (102)   /* CCITT g.722 ADPCM */
#define AUDIO_ENCODING_G723     (103)   /* CCITT g.723 ADPCM */

#if defined (mc68000) || defined (sparc)
#define	DECODE_LONG(from, to)	*((long *)(to)) = *((long *)(from))
#endif /*big-endian*/

#if defined (i386) || defined (__ppc) || defined (DEC) || defined (__alpha)
#define	DECODE_LONG(from, to)						\
			    ((char *)(to))[0] = ((char *)(from))[3];	\
			    ((char *)(to))[1] = ((char *)(from))[2];	\
			    ((char *)(to))[2] = ((char *)(from))[1];	\
			    ((char *)(to))[3] = ((char *)(from))[0];
#endif /*little-endian*/

#ifndef DECODE_LONG

/* Define a generic function to perform the endian conversion.
   Not a good thing to put into the include file, but it will
   have to go here for now. */
void
DECODE_LONG(void *from, void *to)
{
    /* Test whether we live in a big-endian or little-endian world. */
    long testlong = 0x00000001;
    if ( ((char *)&testlong)[0] )
    {
	/* We're little endian. */
	((char *)(to))[0] = ((char *)(from))[3];
	((char *)(to))[1] = ((char *)(from))[2];
	((char *)(to))[2] = ((char *)(from))[1];
	((char *)(to))[3] = ((char *)(from))[0];
    }
    else
    {
	/* We're big endian. */
	*((long *) to) = *((long *) from);
    }
}

#endif

#endif /* !_AU_H */
