/*
 *  ShowErrorDialog()   -   shows the error in a dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   11-Mar-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"
#include "errcds.h"

void ShowErrorDialog (error_code, text)
int
    error_code;
char
    *text;
{
    XmString
        xmstr;
    char
        *message;

    switch (error_code)
    {
        case -1:
        {
            if (text == (char *) NULL)
                message = "File does not Exist!";
            else
                message = text;
            break;
        }
        
        case -4:
        {
            if (text == (char *) NULL)
                message = "File is a directory!";
            else
                message = text;
            break;
        }

        case -2:
        {
            if (text == (char *) NULL)
                message = "File is not a regular file!";
            else
                message = text;
            break;
        }

        case -3:
        {
            if (text == (char *) NULL)
                message = "File is not readable!";
            else
                message = text;
            break;
        }

        case INVALID_ROLODEX_FILE:
        {
            if (text == (char *) NULL)
                message = "File is not in Yrolo format!";
            else
                message = text;
            break;
        }

        case NO_VERSION_STRING:
        {
            if (text == (char *) NULL)
                message = "Yrolo database has no Version String!";
            else
                message = text;
            break;
        }

        case UNEXPECTED_EOF:
        {
            if (text == (char *) NULL)
                message = "Unexpected End of File while reading!";
            else
                message = text;
            break;
        }

        default:
        {
            if (text == (char *) NULL)
                message = "Unknown Error Type!";
            else
                message = text;
            break;
        }
    }

    xmstr = XmStringCreateLtoR (message, XmSTRING_DEFAULT_CHARSET);
    XtVaSetValues (GerrorDialogW,
        XmNmessageString, xmstr,
        NULL);
    XmStringFree (xmstr);
    XtManageChild (GerrorDialogW);
    XBell (XtDisplay(GerrorDialogW), 99);
}
