/*
 *  SendMail()  -   routine to send mail
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   27-Nov-94   first cut
 *      muquit@semcor.com   12-Mar-95   more portable
 */


#include "xhead.h"
#include <sys/param.h>
#include "defines.h"
#include "xymrolo.h"

#ifdef ISC_UNIX
#include <sys/unistd.h>
typedef short pid_t;
#define WNOHANG 1
#endif

/*
** for getrlimit ()
*/

#include <sys/time.h>
#include <sys/resource.h>

void SendMail()
{
    char
        *to = (char *)NULL;
    char
        *subject = (char *)NULL;
    char
        *cc = (char *)NULL;
    char
        *bcc = (char *)NULL;
    char
        *body = (char *) NULL;

    char
        *delivery_agent;

    char
        *buf;

    struct tm
        *loctime;

    FILE
        *fp = (FILE *)NULL;

    time_t
        now;

    char
        timebuf[BUFSIZ];

    char
        **namelist,
        **s;

/*  unportable*/

/*
    union wait
        w;
*/

/*
    struct rlimit
        rlp;
*/

    int
        process_status;
/*
    int
        rlimit_fileno;
*/

    int
        i;

    char
        tmpfile[MaxTextLength];

    int
        pid;

    int
        length;

    TemporaryFilename(tmpfile);

    namelist = (char **)NULL;
    buf = (char *)NULL;

    to = XmTextGetString(w_special[TO_TEXT_W]);

    if ((int) strlen(to) == 0)
    {
        WriteStatusMessage(1,
            messageTextW, "No \"To:\" field, Wil not send Mail...\n");
        goto ExitProcessing;
    }

    length = (int) strlen("sendmail") +
        (int) strlen("-t")+
        (int) strlen("-i") +
        (int) strlen(to);

    subject = XmTextGetString(w_special[SUBJECT_TEXT_W]);
    cc = XmTextGetString (w_special[CC_TEXT_W]);
    bcc = XmTextGetString (w_special[BCC_TEXT_W]);
    body = XmTextGetString (w_special[LETTER_TEXT_W]);

    fp = fopen(tmpfile, "w");

    if (fp == (FILE *) NULL)
    {
        WriteStatusMessage(1,messageTextW,"Could not open temporary file..");
        goto ExitProcessing;
    }

    (void) fprintf(fp, "To: %s\n", to);

    (void) fprintf(fp, "X-Mailer: Yrolo %s by muquit@semcor.com\n", Version);
    if ((int)strlen(subject) > 0)
        (void) fprintf(fp, "Subject: %s\n", subject);

    if ((int) strlen(cc) > 0)
        (void) fprintf(fp, "Cc: %s\n", cc);

    if ((int) strlen(bcc) > 0)
        (void) fprintf(fp, "Bcc: %s\n", bcc);

    (void) fprintf(fp, "\n");

    if ((int) strlen(body) > 0)
        (void) fprintf(fp, "%s\n", body);
            
    (void) fclose((FILE *)fp);

    fp = fopen(tmpfile, "r");

    namelist = (char **) malloc(length*sizeof(char *));

    if (namelist == (char **) NULL)
    {
        Warning("Unable to Allocate memory:", "SendMail()");
        goto ExitProcessing;
    }
    s = namelist;
    *s++ = "sendmail";
    *s++ = "-t";
    *s++ = "-i";
    *s++ = to;
    *s='\0';

            /*
            ** eliminate possible zombies, idea is from Mail
            */
        /*  while (wait3(&w, WNOHANG, (struct timeval *) 0) > 0)
                ;*/

            while (waitpid((pid_t) NULL, &process_status, WNOHANG) > 0)
                ;
            
            /*
            ** fork a child process, mail sending will be done from here
            ** so we do not have to wait, just clik on Send Mail and voila!
            */

            pid = fork();

            if (pid == -1)
            {
                perror("fork");
                goto ExitProcessing;
            }

            if (pid == 0)
            {
                (void) signal(SIGHUP, SIG_IGN);
                (void) signal(SIGINT, SIG_IGN);
                (void) signal(SIGQUIT, SIG_IGN);

                /*
                ** close stdin, and make our file as stdin for
                ** sendmail
                */

                (void) close(0);
                (void) dup(fileno(fp));
/*
                rc = getrlimit (RLIMIT_NOFILE, &rlp);

                if (rc == 0)
                    rlimit_fileno = rlp.rlim_cur;
                else
                    rlimit_fileno = 64;
*/

/*              for(i=getdtablesize(); --i > 2;)  
                    (void) close(i);*/
/*                
                for (i=rlimit_fileno; --i > 2;)
                    (void) close (i);
*/
                for (i=NOFILE; --i > 2;)
                    (void) close (i);

                delivery_agent = SendmailCommand;
#ifdef DEBUG
                (void) fprintf(stderr,
                    "Execing sendmail....!\n");
#endif
                execv(delivery_agent, namelist);
                perror(SendmailCommand);
                exit(1);
            }
            buf = (char *) malloc(MaxTextLength*sizeof(char));
            if (buf == (char *) NULL)
            {   
                Warning("Memory Allocatin Failed!", (char *) NULL);
                goto ExitProcessing;
            }
            else
            {
                now = time(NULL);
                loctime = localtime(&now);

                (void) strftime(timebuf, BUFSIZ,
                    "%I:%M %p", loctime);
                (void) sprintf(buf,"Mail Sent to: %s",to);
                (void) sprintf(buf,"%s [%s]\n",buf,timebuf);
                WriteStatusMessage(0, messageTextW, buf);
            }

ExitProcessing:
    if (namelist != (char **) NULL)
        (void) free ((char *) namelist);

    if (buf != (char *)NULL)
        (void) free ((char *) NULL);

    if (to != (char *) NULL)
        (void) free ((char *)to);

    if (subject != (char *) NULL)
        (void) free ((char *)subject);

    if (cc != (char *) NULL)
        (void) free ((char *)cc);

    if (bcc != (char *) NULL)
        (void) free ((char *)bcc);

    if (body != (char *) NULL)
        (void) free ((char *) body);

    if (fp != (FILE *)NULL)
        (void) fclose ((FILE *) fp);

#ifdef DEBUG
    (void) fprintf(stderr,
        "Removing %s\n", tmpfile);
#endif

    unlink(tmpfile);
return;

}
