/*
 *  MyCopy) -   copies one file to another
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *  1 - error opening source file
 *  2 - error opening dest file
 *  3 - copy was unsuccessfull
 *  0 - everything is fine
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   11/15/94    first cut
 */

#include "xhead.h"
#include "xymrolo.h"
/*#include <sys/file.h>*/

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>


int MyCopy(fromfile, tofile)
char
    *fromfile;
char
    *tofile;
{
    int
        from,
        to;
    
    int
        n;
    
    struct stat
        f_statbuf,
        t_statbuf;
            
    char
        buf[BUFSIZ];

    from = open(fromfile, O_RDONLY);
    if (from < 0)
    {
        Warning("Unable to Open file for reading:", fromfile);
        return 1;
    }

    to = open(tofile, O_WRONLY | O_TRUNC | O_CREAT, 0644);

    if (to < 0)
    {
        Warning("Unable to Open file for writing:", tofile);
        (void) close (from);
        return 2;
    }

    while((n=read(from, buf, sizeof(buf))) > 0)
        write(to, buf, n);
    
    (void) close(from);
    (void) close (to);
    
    /*
    ** check if the copy was perfect
    */

    stat(fromfile, &f_statbuf);
    stat(tofile, &t_statbuf);

    if (f_statbuf.st_size != t_statbuf.st_size)
    {
        return 3;
    }

return 0;
}

#ifdef TEST
main(argc, argv)
int
    argc;
char
    **argv;
{
    int
        rc = 0;
    if(argc < 3)
    {
        (void) fprintf (stderr, "Usage: mycp fromfile tofile\n");
        exit(-1);
    }
        rc = MyCopy(argv[1], argv[2]);

    switch(rc)
    {
        case 0:
        {
            (void) fprintf (stderr, "ALL FINE!\n");
            break;
        }

        case 1:
        {
            (void) fprintf (stderr, 
                "ERROR opening file for reading\n");
            break;
        }

        case 2:
        {
            (void) fprintf (stderr,
                "ERROR opening file for writing\n");
            break;
        }
        
        case 3:
        {
            (void) fprintf (stderr, "Copying Failed\n");
            break;
        }
    }
}
#endif /* TEST */
