/*
 *  GetCardName()   - returns name from the card
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      borrowed from mrolo
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/12/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"

RoloRec *GetN(n)
int
    n;
{
    RoloRec
        *rr;
    
    for (rr=RoloList; rr != (RoloRec *) NULL && ! rr->on;rr=rr->next);

    for (; rr != (RoloRec *) NULL; rr = rr->next)
    {
        if (rr->on)
            n--;
        if (n < 0)
            break;
    }
    return rr;
}

char *GetCardName (n)
int
    n;
{
    RoloRec
        *rr;
    
    rr = GetN(n);
    return (rr ? rr->name : "");
}

char *GetCompanyName (n)
int
    n;
{
    RoloRec
        *rr;

    rr = GetN(n);
    return (rr ? rr->company : "");
}

char *GetEmail(n)
int
    n;
{
    RoloRec
        *rr;
    rr = GetN(n);
    return (rr ? rr->email: "");
}

char *GetNumber1(n)
int
    n;
{
    RoloRec
        *rr;
    rr = GetN(n);
    return (rr ? rr->number : "");
}

char *GetNumber2(n)
int
    n;
{
    RoloRec
        *rr;
    rr = GetN(n);
    return(rr ? rr->number2 : "");
}

char *GetNumber3(n)
int
    n;
{
    RoloRec
        *rr;
    rr = GetN(n);
    return (rr ? rr->number3 : "");
}

char *GetAddress(n)
int
    n;
{
    RoloRec
        *rr;
    rr = GetN(n);
    return (rr ? rr->address : "");
}

char *GetAddress2(n)
int
    n;
{
    RoloRec
        *rr;

    rr = GetN(n);
    return (rr ? rr->address2 : "");

}

char *GetText(n)
int
    n;
{
    RoloRec
        *rr;
    
    rr = GetN(n);
    return (rr ? rr->text: "");
}

int GetIndex(s)
char
    *s;
{
    RoloRec
        *rr;
    int
        n;
    
    for (rr=RoloList, n = 0; rr != (RoloRec *) NULL; rr=rr->next, n++)
    /*  if (rr->on && mystrcasecmp(rr->name,s) >= 0 )*/
        if (rr->on && strcmp(rr->name,s) == 0 )
            break;
    return n;
}

int GetIndex2(s)
char
    *s;
{
    RoloRec
        *rr;
    int
        n;

    for (rr=RoloList, n = 0; rr != (RoloRec *) NULL; rr=rr->next, n++)
      if (rr->on && mystrcasecmp(rr->name,s) >= 0 )
            break;
    return n;
}

