/*
 *  ExpandTilde()   - if the first character is ~, expand the filename  
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      This functions expands a filename starts with ~
 *      ~joe/file.gif will be expaned to the user joe's home directory
 *      ~/file.gif will be expanded to the user who is running the prog.
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *      True    if succeeds
 *      False   if fails
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      filename points to a allocated space. the space must be allocated
 *      at the calling routine. And this routine assumes the space is large
 *      enough to hold a long path name, it will bomb otherwise.
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   16-Mar-95   first cut
 */


#include "xhead.h"
#include "xymrolo.h"
#include <pwd.h>

#ifndef True
#define True    1
#endif

#ifndef False
#define False   0
#endif

#ifndef MaxTextLength
#define MaxTextLength   2048
#endif

/*#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <pwd.h>
*/

unsigned int ExpandTilde (filename)
char
    *filename;
{
    struct
        passwd *ptr;

    char
        *tmp_filename;

    char
        login_name[64];

    char
        *p,
        *q,
        *r;

    unsigned int
        status = True;

    if (*filename != '~')
        return (True);

    *login_name = '\0';

    /*
    ** allocate temporay space 
    */

    tmp_filename = (char *) malloc ((int) strlen(filename));

    if (tmp_filename == (char *) NULL)
    {
        (void) fprintf(stderr,
            "ExpandTilde(): Memory Allocation failed!\n");
        return (False);
    }

    /*
    ** check if there is a / after ~
    */

    p = (char *) strchr (filename, '/');

    if (p == (char *) NULL)     /* no / after ~ */
        for (p=filename; *p != '\0'; p++);
    else
    {

        /*
        ** check if there's anything between ~ and / 
        ** If there is something, this is the login name of a user. 
        ** example: ~someone/file.gif
        */

        r=login_name;
        q=filename+1;

        while (q < p)
            *r++=*q++;
        *r = '\0';
    }


    if (*login_name != '\0')
    {
        /*
        ** get the user's home directory
        */

        setpwent();
        ptr = getpwnam(login_name);

        if (ptr == (struct passwd *) NULL)
        {
            char
                message[300];
            *message = '\0';
            (void) fprintf(stderr,
                "ExpandTilde(): user name %s not found\n", 
                    login_name);
            (void) free ((char *) tmp_filename);
(void) sprintf (message, "User %s does not exist!, rolodex not saved!", login_name);
#ifndef TEST
            WriteStatus(1,rolomessageTextW, message);
#endif
            return (False);
        }
        endpwent ();
        (void) strcpy (tmp_filename, ptr->pw_dir);
        (void) strcat (tmp_filename, p);
    }
    else
    {
        char
            *homedir;

        /*
        ** get the home directory
        */

        if (*p == '\0')
            return (True);

        homedir = (char *) getenv ("HOME");
        
        if (homedir == (char *) NULL)
        {
            char
                *username;
            /*
            ** try to get the user name
            */

            username = (char *) getlogin();
            if (username == (char *) NULL)
                username = cuserid ((char *) NULL);
                    if (username == (char *) NULL)
                    {
                        setpwent();
                        if ((ptr = getpwuid ((uid_t) getuid())) 
                            != (struct passwd *) NULL)
                        
                            username = ptr->pw_name;
                        else
                        {
                            (void) fprintf(stderr,
                                "You do not exists!\n");
                            (void) free ((char *) tmp_filename);
                            return (False);
                        }
                        endpwent();
                    }
            
            setpwent();
            ptr = getpwnam(username);
            (void) strcpy(tmp_filename, ptr->pw_dir);
            (void) strcat(tmp_filename, p);
            endpwent();
        }
        else
        {
            (void) strcpy (tmp_filename, homedir);
                (void) strcat (tmp_filename, p);
        }


    }

    (void) strcpy (filename, tmp_filename);

    (void) free ((char *) tmp_filename);
return (status);
}

#ifdef TEST

void main(argc, argv)
int 
    argc;
char
    **argv;
{
    char
        filename[MaxTextLength];
    
    unsigned int
        status;

    (void) strcpy (filename, argv[1]);

    status = ExpandTilde (filename);

    if (status == False)
    {
        (void) fprintf(stderr, "Unable to Expand filename %s\n",
            filename);      
    }
    else
        (void) fprintf(stderr,
            "Expanded filename: %s\n", filename);
}

#endif /* TEST */
