/*
 *  CreateMailDialog()  -   create mail sending dialog
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/25/94    muquit  first cut
 */

#include "xhead.h"
#include "xymrolo.h"

#define TIGHTNESS 20
#define NUMBER_OF_BUTTONS 4

Boolean CreateMailDialog(parent)
Widget
    parent;
{
    Arg
        args[20];
    int
        n;
    
    int
        i;

    static Widget
        formW,
        paneW,
        controlformW,
        rowcolW,
        labformW,
        actionformW,
        textW,
        buttonW,
        messageLabelW,
        letterTextW;

    Widget
        vsbW,
        hsbW;

    Pixel
        scb_bg;

    static char
        *Labels[] =
        {
            "To", "Subject", "Cc", "Bcc",
        };

    char
        *label[4];

    label[0] = "Sign";
    label[1] = "Send Mail";
    label[2] = "Include File";
    label[3] = "Cancel";

    
    /*
    ** create the base form
    */


    formW = XmCreateFormDialog(parent, "Sendmail",
        args, 0);
    
    w_special[MAIL_FORMD_W] = formW;

    XtVaSetValues (XtParent(formW), XmNtitle, "Send Mail", NULL);

    /*
    ** create a pane
    */

    paneW = XtVaCreateWidget("Mailpane",
        xmPanedWindowWidgetClass, formW,
        XmNsashWidth,           1,
        XmNsashHeight,          1,
        XmNtopAttachment,       XmATTACH_FORM,
        XmNbottomAttachment,    XmATTACH_FORM,
        XmNleftAttachment,      XmATTACH_FORM,
        XmNrightAttachment,     XmATTACH_FORM,
        NULL);

    /*
    ** create form for control area
    */

    controlformW = XtVaCreateWidget ("MControlform",
        xmFormWidgetClass, paneW,
        NULL);

    /*
    ** create a rowcol W
    */
    rowcolW = XtVaCreateWidget ("Mrowcol",
        xmRowColumnWidgetClass, controlformW,
        NULL);

    for (i=0; i < XtNumber(Labels); i++)
    {
        labformW = XtVaCreateWidget("Labform",
            xmFormWidgetClass, rowcolW,
            XmNfractionBase, 10,
            NULL);

        XtVaCreateManagedWidget(Labels[i],
            xmLabelWidgetClass, labformW,
            XmNtopAttachment, XmATTACH_FORM,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNleftAttachment, XmATTACH_FORM,
            XmNrightAttachment, XmATTACH_POSITION,
            XmNrightPosition, 3,
            XmNalignment, XmALIGNMENT_END,
            NULL);

        textW = XtVaCreateManagedWidget ("Ltext",
            xmTextWidgetClass, labformW,
            XmNeditMode, XmSINGLE_LINE_EDIT,
            XmNrightAttachment, XmATTACH_FORM,
            XmNleftAttachment, XmATTACH_POSITION,
            XmNcolumns, (short)35,
            XmNrows, (short) 1,
            XmNleftPosition, 4,
            NULL);

        switch(i)
        {
            case 0:
            {
                w_special[TO_TEXT_W] = textW;
                break;
            }   

            case 1:
            {
                w_special[SUBJECT_TEXT_W] = textW;
                break;
            }

            case 2:
            {
                w_special[CC_TEXT_W] = textW;
                break;
            }
            
            case 3:
            {
                w_special[BCC_TEXT_W] = textW;
                break;
            }
        }
        XtAddCallback(textW, XmNactivateCallback, ReturnHit, NULL);
        XtManageChild (labformW);
    }

    /*
    ** Create the Message label
    */
    messageLabelW = XtVaCreateManagedWidget ("MessageLab",
        xmLabelWidgetClass, controlformW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, rowcolW,
        XmNtopOffset, (int) 20,
        NULL);
    /*
    ** Create the letter body text Widget
    */

    n = 0;
    XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT);  n++;
    XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
/*  XtSetArg (args[n], XmNtopWidget, rowcolW); n++;*/
    XtSetArg (args[n], XmNtopWidget, messageLabelW); n++;
/*  XtSetArg (args[n], XmNtopOffset, (int)20);  n++;*/

    letterTextW = XmCreateScrolledText ( controlformW, "Emailbody",
        args, n);

    w_special[LETTER_TEXT_W] = letterTextW;
    /*
    ** send mail if user pressed ^D
    */
    XtAddCallback (letterTextW, XmNactivateCallback,
        MailCB, (XtPointer) 1);

    
    /*
    ** craete MessageText Widget
    */
    n = 0;
    XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT);  n++;
    XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, letterTextW); n++;
    XtSetArg (args[n], XmNtopOffset, (int)5);  n++;
    XtSetArg (args[n], XmNscrollHorizontal, False); n++;
    XtSetArg (args[n], XmNeditable, False); n++;
    XtSetArg (args[n], XmNcursorPositionVisible, False);n++;
    XtSetArg (args[n], XmNwordWrap, True);  n++;
    XtSetArg (args[n], XmNbottomAttachment, XmATTACH_FORM); n++;

    /*
    ** it's global
    */

    messageTextW = XmCreateScrolledText (controlformW,"Messagetext",
        args, n);

        
    /*
    ** set the scroll bar colors
    */

    scb_bg = (Pixel) AllocateNamedColor(XtDisplay(w_special[TOPLEVEL_W]), 
        scb_bgcolor);

    if (scb_bg > 256)   /* Parse error */
    {
        /*
        ** set the color as same as the bg of the toplevel W
        */
        XtVaGetValues(w_special[TOPLEVEL_W],
            XmNbackground, &scb_bg,
            NULL);
    }

    XtVaGetValues(XtParent(letterTextW),
        XmNverticalScrollBar, &vsbW,
        XmNhorizontalScrollBar, &hsbW,
        NULL);
    
    SetScrollbarColors(vsbW, hsbW, scb_bg);

    /*
    ** create form for action area
    */

    actionformW = XtVaCreateWidget("Actionform",
        xmFormWidgetClass, paneW,
        XmNfractionBase, TIGHTNESS*NUMBER_OF_BUTTONS-1,
        NULL);
        
    /*
    ** create push buttons
    */

    for (i=0; i < NUMBER_OF_BUTTONS; i++)
    {

#ifdef DEBUG2
    (void) fprintf (stderr, "pblabels:%s\n",label[i]);
#endif

        buttonW = XtVaCreateManagedWidget (label[i],
            xmPushButtonWidgetClass, actionformW,
            /*
            XmNshowAsDefault,                  i == 0,
            */
            XmNleftAttachment, i ? XmATTACH_POSITION : XmATTACH_FORM,
            XmNleftPosition,    TIGHTNESS*i,
            XmNtopAttachment, XmATTACH_FORM,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNrightAttachment,
                i != NUMBER_OF_BUTTONS-1 ? XmATTACH_POSITION : XmATTACH_FORM,
            XmNrightPosition, TIGHTNESS*i+(TIGHTNESS-1),
            NULL);

        XtAddCallback (buttonW, XmNactivateCallback, MailCB,
            (XtPointer) i);

        if (i==0)
        {
            Dimension
                height = (Dimension) 0;
            Dimension
                h = (Dimension) 0;

            XtVaGetValues (actionformW, 
                XmNmarginHeight, &h,
                NULL);
            
            height +=h<<1;

            XtVaSetValues (buttonW,
                XmNdefaultButton, buttonW,
                XmNpaneMaximum, height,
                XmNpaneMinimum, height,
                NULL);
            

        }
    }

    XtManageChild (rowcolW);
    XtManageChild (actionformW);
    XtManageChild (messageTextW);
    XtManageChild (letterTextW);
    /*
    XtManageChild (BccTextW);
    XtManageChild (CcTextW);
    XtManageChild (SubjectTextW);
    XtManageChild (toTextW);
    */
    XtManageChild (controlformW);
    XtManageChild (paneW);
    
    return (True);
}
