/******************************************************************************
 * $RCSfile: xwhowidget.c,v $   $Revision: 1.9 $
 * Copyright (C) 1994  Technische Universitaet Muenchen
 ******************************************************************************/

#include "xwho.h"


/*----------------------------------------------------------------------------*
 * extern variables
 *----------------------------------------------------------------------------*/

string noserver = NULL;
string nouser = NULL;


/*----------------------------------------------------------------------------*
 * intern variables
 *----------------------------------------------------------------------------*/

static list widgetlines = NULL;
static list line = NULL;
static list column = NULL;

static Widget layout;
static int linecount, columncount;
static int maxcolumns = 0;


/*----------------------------------------------------------------------------*
 * intern prototypes
 *----------------------------------------------------------------------------*/

static int
    GetMaxColumns_widgetlines();


static int
    GetColumns_xwhowidgets(xwhowidgets);

static void
    Free_xwhowidget(void**);


/*----------------------------------------------------------------------------*
 * functions
 *----------------------------------------------------------------------------*/

/*--- widgetlines ------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
int
    Empty_widgetlines()
{
	return (Empty_list(widgetlines));
}


/*----------------------------------------------------------------------------*/
void
    Add_widgetlines(xwhowidgets line)
{
	AppendTrue_list(&widgetlines, (void*)line);
}


/*----------------------------------------------------------------------------*/
xwhowidget
    RetrieveHost_widgetlines()
{
	xwhowidget w = NULL;

	while (w == NULL) {
		if (line == NULL  &&  column == NULL) {
			line = widgetlines;
			column = (list)First_list(line);
		}
		else
		    if ((column = Next_list(column)) == NULL) {
			    if ((line = Next_list(line)) == NULL)
				return (NULL);
			    else
				column = (list)First_list(line);
		    }
		w = (xwhowidget)First_list(column);
		if (w->wtype != HOST_W)
		    w = NULL;
	}
	return (w);
}


/*----------------------------------------------------------------------------*/
xwhowidget
    SeekHost_widgetlines(char* hostname)
{
	xwhowidget w = NULL;
	list line_bak = line;
	list column_bak = column;

	line = column = NULL;
	while ((w = RetrieveHost_widgetlines())  !=  NULL) {
		if (HasHostname_xwhowidget(w, hostname))
		    break;
	}
	line = line_bak;
	column = column_bak;
	return (w);
}


/*----------------------------------------------------------------------------*/
void
    Create_widgetlines(Widget parent)
{
	linecount = 0;
	layout = XtVaCreateManagedWidget("xwhoLayout", xpTableWidgetClass,
					 parent, NULL);
	maxcolumns = GetMaxColumns_widgetlines();
	InOrder_list(widgetlines, Create_xwhowidgets);
}


/*----------------------------------------------------------------------------*/
void
    Destroy_widgetlines()
{
	DestroyLastPopup();
	if (toplevel != NULL) {
		XtDestroyWidget(toplevel);
		toplevel = NULL;
	}
	Free_widgetlines();
}


/*----------------------------------------------------------------------------*/
static int
    GetMaxColumns_widgetlines()
{
	list l;
	int max = 0;

	for (l = widgetlines; ! Empty_list(l); l = Next_list(l)) {
		int columns = GetColumns_xwhowidgets(First_list(l));

		if (columns > max)
		    max = columns;
	}
	return (max);
}


/*----------------------------------------------------------------------------*/
void
    Update_widgetlines(xwhodservedhost h)
{
	xwhowidget w = SeekHost_widgetlines(h->hostname);

	if (w != NULL)
	    Update_xwhowidget(w, h);
}


/*----------------------------------------------------------------------------*/
void
    Free_widgetlines()
{
	Free_list(&widgetlines, Free_xwhowidgets);
}


/*--- xwhowidgets ------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhowidgets
    New_xwhowidgets()
{
	return (NULL);
}


/*----------------------------------------------------------------------------*/
void
    Create_xwhowidgets(void* line)
{
	columncount = 0;
	InOrder_list((list)line, Create_xwhowidget);
	if (columncount < maxcolumns) {
		xwhowidget w = Init_xwhowidget(LABEL_W, "");

		w->columns = maxcolumns - columncount;
		Create_xwhowidget(w);
		Free_xwhowidget((void**)&w);
	}
	linecount++;
}


/*----------------------------------------------------------------------------*/
static int
    GetColumns_xwhowidgets(xwhowidgets line)
{
	list l;
	int columns = 0;

	for (l = line; ! Empty_list(l); l = Next_list(l)) {
		xwhowidget w = First_list(l);

		columns += w->columns;
	}
	return (columns);
}


/*----------------------------------------------------------------------------*/
void
    Free_xwhowidgets(void** line_ref)
{
	Free_list((list*)line_ref, Free_xwhowidget);
}


/*--- xwhowidget -------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
xwhowidget
    New_xwhowidget()
{
	xwhowidget neww;

	neww = (xwhowidget)TrueReAlloc(NULL, 1, sizeof(struct xwhowidget));
	neww->wtype = LABEL_W;
	neww->widget = NULL;
	neww->columns = 1;
	neww->label = NULL;
	neww->host.name = NULL;
	neww->host.utype = NO_T;
	neww->host.login = NULL;
	neww->host.rlogins = NULL;

	return (neww);
}


/*----------------------------------------------------------------------------*/
xwhowidget
    Init_xwhowidget(enum xwhowidgettype type,
		    string str)
{
	xwhowidget neww = New_xwhowidget();

	neww->wtype = type;

	switch (type) {
	    case HOST_W:
		StrTrueReAlloc(&(neww->label), noserver);
		StrTrueReAlloc(&(neww->host.name), GetHostnameByName(str));
		break;
	    case LABEL_W:
		StrTrueReAlloc(&(neww->label), str);
		break;
	    case MENU_W:
		StrTrueReAlloc(&(neww->label), "MENU");
		break;
	    default:
		Error(-1, "unknown widget-type specified");
	}

	return (neww);
}


/*----------------------------------------------------------------------------*/
void
    Create_xwhowidget(void* widget)
{
	xwhowidget w = (xwhowidget)widget;

	switch (w->wtype) {
	    case HOST_W:
		w->widget =
		    XtVaCreateManagedWidget("xwhoButton", commandWidgetClass,
					    layout,
					    XtNlabel, w->label, NULL);
		XtAddCallback(w->widget, XtNcallback,
			      (XtCallbackProc)UserClick, (XtPointer)w);
		XpTableChildConfig(w->widget,
				   columncount, linecount, w->columns, 1,
				   FORMOPT);
		break;
	    case LABEL_W:
		w->widget =
		    XtVaCreateManagedWidget("xwhoLabel", labelWidgetClass,
					    layout,
					    XtNlabel, w->label, NULL);
		XpTableChildConfig(w->widget,
				   columncount, linecount, w->columns, 1,
				   FORMOPT);
		break;
	    case MENU_W:
		CreateXWhoMenu(layout, w, columncount, linecount);
		break;
	    default:
		Error(-1, "widgetlines contains wrong widget-type");
	}
	columncount += w->columns;
}


/*----------------------------------------------------------------------------*/
int
    HasHostname_xwhowidget(xwhowidget w,
			   char* hostname)
{
	return (w->wtype == HOST_W  &&  strcmp(hostname,w->host.name) == 0);
}


/*----------------------------------------------------------------------------*/
void
    Update_xwhowidget(xwhowidget w,
		      xwhodservedhost h)
{
	xwhologin l;
	xwhonick mynick;

	StrTrueReAlloc(&(w->label), nouser);
	w->host.utype = USER_T;
	Free_xwhologin((void**)&(w->host.login));
	Free_xwhologins((void**)&(w->host.rlogins));
	while ((l = TakeOut_xwhologins(&(h->logins)))  !=  NULL) {
		xwhonick n = Seek_nicklist(l->login);
		if (n != NULL)
		    StrTrueReAlloc(&(l->nick), n->nick);
		else
		    StrTrueReAlloc(&(l->nick), NULL);
		if (IsLocal_xwhologin(l)) {
			if (w->host.login == NULL) {
				if (n != NULL) {
					w->host.utype = GROUP_T;
					mynick = n;
				}
				else
				    if ((l->nick)[0] != '\0')
					w->host.utype = ALIAS_T;
				if (strcmp(l->login, mylogin) == 0)
				    w->host.utype = ME_T;
				if ((l->nick)[0] != '\0')
				    StrTrueReAlloc(&(w->label), l->nick);
				else
				    StrTrueReAlloc(&(w->label), l->login);
				w->host.login = l;
				l = NULL;
			}
			else
			    Warning("can't ascertain user of %s", w->host.name);
		}
		if (l != NULL)
		    Add_xwhologins(&(w->host.rlogins), l);
	}

	XtVaSetValues(w->widget, XtNlabel, w->label, NULL);

	switch (w->host.utype) {
	    case NO_T:
		XtVaSetValues(w->widget,
			      XtNforeground, noforeground,
			      XtNbackground, nobackground,
			      NULL);
		break;
	    case USER_T:
		XtVaSetValues(w->widget,
			      XtNforeground, userforeground,
			      XtNbackground, userbackground,
			      NULL);
		break;
	    case ALIAS_T:
		XtVaSetValues(w->widget,
			      XtNforeground, aliasforeground,
			      XtNbackground, aliasbackground,
			      NULL);
		break;
	    case GROUP_T:
		XtVaSetValues(w->widget,
			      XtNforeground, mynick->foreground,
			      XtNbackground, mynick->background,
			      NULL);
		break;
	    case ME_T:
		XtVaSetValues(w->widget,
			      XtNforeground, myforeground,
			      XtNbackground, mybackground,
			      NULL);
		break;
	}

	UpdateLastPopup(w);
}


/*----------------------------------------------------------------------------*/
static void
    Free_xwhowidget(void** w_ref)
{
	xwhowidget w = *w_ref;

	if (w != NULL) {
		StrFree(&(w->label));
		StrFree(&(w->host.name));
		Free_xwhologin((void**)&(w->host.login));
		Free_xwhologins((void**)&(w->host.rlogins));
		Free(w_ref);
	}
}
